/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.iam.java.client.api;

import com.nutanix.dp1.iam.iam.v4.authn.ConnectionDirectoryServiceApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.CreateDirectoryServiceApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.DeleteDirectoryServiceApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.DirectoryService;
import com.nutanix.dp1.iam.iam.v4.authn.DirectoryServiceConnectionRequest;
import com.nutanix.dp1.iam.iam.v4.authn.DirectoryServiceSearchQuery;
import com.nutanix.dp1.iam.iam.v4.authn.GetDirectoryServiceApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.ListDirectoryServicesApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.SearchDirectoryServiceApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.UpdateDirectoryServiceApiResponse;
import com.nutanix.iam.java.client.ApiClient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.iam.java.client.api.DirectoryServicesApi")
public class DirectoryServicesApi {
    private static final Logger log = LoggerFactory.getLogger(DirectoryServicesApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public DirectoryServicesApi() {
        this(new ApiClient());
    }

    @Autowired
    public DirectoryServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConnectionDirectoryServiceApiResponse connectionStatusDirectoryService(String extId, DirectoryServiceConnectionRequest body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        DirectoryServiceConnectionRequest postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling connectionStatusDirectoryService");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling connectionStatusDirectoryService");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/directory-services/{extId}/$actions/verify-connection-status").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ConnectionDirectoryServiceApiResponse> returnType = new ParameterizedTypeReference<ConnectionDirectoryServiceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public CreateDirectoryServiceApiResponse createDirectoryService(DirectoryService body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        DirectoryService postBody = body;
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createDirectoryService");
        }
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/directory-services").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<CreateDirectoryServiceApiResponse> returnType = new ParameterizedTypeReference<CreateDirectoryServiceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public DeleteDirectoryServiceApiResponse deleteDirectoryServiceById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling deleteDirectoryServiceById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/directory-services/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<DeleteDirectoryServiceApiResponse> returnType = new ParameterizedTypeReference<DeleteDirectoryServiceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.DELETE, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetDirectoryServiceApiResponse getDirectoryServiceById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getDirectoryServiceById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/directory-services/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetDirectoryServiceApiResponse> returnType = new ParameterizedTypeReference<GetDirectoryServiceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ListDirectoryServicesApiResponse listDirectoryServices(Integer $page, Integer $limit, String $filter, String $orderby, String $select, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/directory-services").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$orderby", $orderby));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$select", $select));
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ListDirectoryServicesApiResponse> returnType = new ParameterizedTypeReference<ListDirectoryServicesApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public SearchDirectoryServiceApiResponse searchDirectoryService(String extId, DirectoryServiceSearchQuery body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        DirectoryServiceSearchQuery postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling searchDirectoryService");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling searchDirectoryService");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/directory-services/{extId}/$actions/search").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<SearchDirectoryServiceApiResponse> returnType = new ParameterizedTypeReference<SearchDirectoryServiceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public UpdateDirectoryServiceApiResponse updateDirectoryServiceById(String extId, DirectoryService body, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        DirectoryService postBody = body;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling updateDirectoryServiceById");
        }
        if (body == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling updateDirectoryServiceById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/directory-services/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<UpdateDirectoryServiceApiResponse> returnType = new ParameterizedTypeReference<UpdateDirectoryServiceApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.PUT, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

