/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authz.AttributeEntity;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entity
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Entity.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    @Size(min=1, max=255)
    @JsonProperty(value="name")
    public @Size(min=1, max=255) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @Pattern(regexp="^[^\\\"]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="displayName")
    public @Pattern(regexp="^[^\\\"]*$") @Size(min=1, max=255) String displayName = null;
    @Size(min=1, max=255)
    @JsonProperty(value="clientName")
    public @Size(min=1, max=255) String clientName = null;
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    @Size(min=3, max=2000)
    @JsonProperty(value="searchURL")
    public @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") @Size(min=3, max=2000) String searchURL = null;
    @Size(min=0, max=10)
    @JsonProperty(value="attributeList")
    public @Size(min=0, max=10) List<AttributeEntity> attributeList = null;
    @JsonProperty(value="isLogicalAndSupportedForAttributes")
    public Boolean isLogicalAndSupportedForAttributes = null;

    public Entity() {
    }

    public Entity(String tenantId, String extId, List<ApiLink> links, String name, String description, String displayName, String clientName, String searchURL, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy, List<AttributeEntity> attributeList, Boolean isLogicalAndSupportedForAttributes) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setDisplayName(displayName);
        this.setClientName(clientName);
        this.setSearchURL(searchURL);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
        this.setAttributeList(attributeList);
        this.setIsLogicalAndSupportedForAttributes(isLogicalAndSupportedForAttributes);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.Entity";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public static EntityBuilder EntityBuilder() {
        return new EntityBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$searchURL = this.getSearchURL();
        String other$searchURL = other.getSearchURL();
        if (this$searchURL == null ? other$searchURL != null : !this$searchURL.equals(other$searchURL)) {
            return false;
        }
        List<AttributeEntity> this$attributeList = this.getAttributeList();
        List<AttributeEntity> other$attributeList = other.getAttributeList();
        if (this$attributeList == null ? other$attributeList != null : !((Object)this$attributeList).equals(other$attributeList)) {
            return false;
        }
        Boolean this$isLogicalAndSupportedForAttributes = this.getIsLogicalAndSupportedForAttributes();
        Boolean other$isLogicalAndSupportedForAttributes = other.getIsLogicalAndSupportedForAttributes();
        return !(this$isLogicalAndSupportedForAttributes == null ? other$isLogicalAndSupportedForAttributes != null : !((Object)this$isLogicalAndSupportedForAttributes).equals(other$isLogicalAndSupportedForAttributes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Entity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $searchURL = this.getSearchURL();
        result = result * 59 + ($searchURL == null ? 43 : $searchURL.hashCode());
        List<AttributeEntity> $attributeList = this.getAttributeList();
        result = result * 59 + ($attributeList == null ? 43 : ((Object)$attributeList).hashCode());
        Boolean $isLogicalAndSupportedForAttributes = this.getIsLogicalAndSupportedForAttributes();
        result = result * 59 + ($isLogicalAndSupportedForAttributes == null ? 43 : ((Object)$isLogicalAndSupportedForAttributes).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getSearchURL() {
        return this.searchURL;
    }

    public List<AttributeEntity> getAttributeList() {
        return this.attributeList;
    }

    public Boolean getIsLogicalAndSupportedForAttributes() {
        return this.isLogicalAndSupportedForAttributes;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="clientName")
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @JsonProperty(value="searchURL")
    public void setSearchURL(String searchURL) {
        this.searchURL = searchURL;
    }

    @JsonProperty(value="attributeList")
    public void setAttributeList(List<AttributeEntity> attributeList) {
        this.attributeList = attributeList;
    }

    @JsonProperty(value="isLogicalAndSupportedForAttributes")
    public void setIsLogicalAndSupportedForAttributes(Boolean isLogicalAndSupportedForAttributes) {
        this.isLogicalAndSupportedForAttributes = isLogicalAndSupportedForAttributes;
    }

    @Override
    public String toString() {
        return "Entity(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", clientName=" + this.getClientName() + ", searchURL=" + this.getSearchURL() + ", attributeList=" + this.getAttributeList() + ", isLogicalAndSupportedForAttributes=" + this.getIsLogicalAndSupportedForAttributes() + ")";
    }

    public static class EntityBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private String displayName;
        private String clientName;
        private String searchURL;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;
        private List<AttributeEntity> attributeList;
        private Boolean isLogicalAndSupportedForAttributes;

        EntityBuilder() {
        }

        public EntityBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public EntityBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public EntityBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public EntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        public EntityBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public EntityBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public EntityBuilder searchURL(String searchURL) {
            this.searchURL = searchURL;
            return this;
        }

        public EntityBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public EntityBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public EntityBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public EntityBuilder attributeList(List<AttributeEntity> attributeList) {
            this.attributeList = attributeList;
            return this;
        }

        public EntityBuilder isLogicalAndSupportedForAttributes(Boolean isLogicalAndSupportedForAttributes) {
            this.isLogicalAndSupportedForAttributes = isLogicalAndSupportedForAttributes;
            return this;
        }

        public Entity build() {
            return new Entity(this.tenantId, this.extId, this.links, this.name, this.description, this.displayName, this.clientName, this.searchURL, this.createdTime, this.lastUpdatedTime, this.createdBy, this.attributeList, this.isLogicalAndSupportedForAttributes);
        }

        public String toString() {
            return "Entity.EntityBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", displayName=" + this.displayName + ", clientName=" + this.clientName + ", searchURL=" + this.searchURL + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ", attributeList=" + this.attributeList + ", isLogicalAndSupportedForAttributes=" + this.isLogicalAndSupportedForAttributes + ")";
        }
    }
}

