/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authz.EntityFilter;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAuthorizationPolicy
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(BaseAuthorizationPolicy.class);
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(max=255)
    private @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(max=255) String clientName = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="displayName")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String displayName = null;
    @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$")
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Pattern(regexp="^[^<>;()&+%/\\\\\"`]*$") @Size(max=1000) String description = null;
    @Size(min=1, max=500)
    @JsonProperty(value="entities")
    public @Size(min=1, max=500) List<EntityFilter> entities = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @Size(max=255)
    @JsonProperty(value="role")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") @Size(max=255) String role = null;

    public BaseAuthorizationPolicy() {
    }

    public BaseAuthorizationPolicy(String tenantId, String extId, List<ApiLink> links, String displayName, String description, String clientName, List<EntityFilter> entities, String role) {
        super(tenantId, extId, links);
        this.setDisplayName(displayName);
        this.setDescription(description);
        this.setClientName(clientName);
        this.setEntities(entities);
        this.setRole(role);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.BaseAuthorizationPolicy";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setClientName(String clientName) {
        if (this.clientName == null) {
            this.clientName = clientName;
        } else {
            log.warn("Read-only property clientName already contains a non-null value and cannot be set again");
        }
    }

    public static BaseAuthorizationPolicyBuilder BaseAuthorizationPolicyBuilder() {
        return new BaseAuthorizationPolicyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseAuthorizationPolicy)) {
            return false;
        }
        BaseAuthorizationPolicy other = (BaseAuthorizationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<EntityFilter> this$entities = this.getEntities();
        List<EntityFilter> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseAuthorizationPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<EntityFilter> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<EntityFilter> getEntities() {
        return this.entities;
    }

    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="entities")
    public void setEntities(List<EntityFilter> entities) {
        this.entities = entities;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public String toString() {
        return "BaseAuthorizationPolicy(clientName=" + this.getClientName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", entities=" + this.getEntities() + ", role=" + this.getRole() + ")";
    }

    public static class BaseAuthorizationPolicyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String displayName;
        private String description;
        private String clientName;
        private List<EntityFilter> entities;
        private String role;

        BaseAuthorizationPolicyBuilder() {
        }

        public BaseAuthorizationPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BaseAuthorizationPolicyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public BaseAuthorizationPolicyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public BaseAuthorizationPolicyBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public BaseAuthorizationPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public BaseAuthorizationPolicyBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public BaseAuthorizationPolicyBuilder entities(List<EntityFilter> entities) {
            this.entities = entities;
            return this;
        }

        public BaseAuthorizationPolicyBuilder role(String role) {
            this.role = role;
            return this;
        }

        public BaseAuthorizationPolicy build() {
            return new BaseAuthorizationPolicy(this.tenantId, this.extId, this.links, this.displayName, this.description, this.clientName, this.entities, this.role);
        }

        public String toString() {
            return "BaseAuthorizationPolicy.BaseAuthorizationPolicyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", displayName=" + this.displayName + ", description=" + this.description + ", clientName=" + this.clientName + ", entities=" + this.entities + ", role=" + this.role + ")";
        }
    }
}

