/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authz.AuthorizationPolicyType;
import com.nutanix.dp1.iam.iam.v4.authz.BaseAuthorizationPolicy;
import com.nutanix.dp1.iam.iam.v4.authz.EntityFilter;
import com.nutanix.dp1.iam.iam.v4.authz.IdentityFilter;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationPolicy
extends BaseAuthorizationPolicy
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationPolicy.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    private Boolean isSystemDefined = true;
    private Integer assignedUsersCount = null;
    private Integer assignedUserGroupsCount = null;
    @Size(min=1, max=600)
    @JsonProperty(value="identities")
    public @Size(min=1, max=600) List<IdentityFilter> identities = null;
    @JsonProperty(value="authorizationPolicyType")
    public AuthorizationPolicyType authorizationPolicyType = null;

    public AuthorizationPolicy() {
    }

    public AuthorizationPolicy(String tenantId, String extId, List<ApiLink> links, String displayName, String description, String clientName, List<EntityFilter> entities, String role, List<IdentityFilter> identities, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy, Boolean isSystemDefined, AuthorizationPolicyType authorizationPolicyType, Integer assignedUsersCount, Integer assignedUserGroupsCount) {
        super(tenantId, extId, links, displayName, description, clientName, entities, role);
        this.setIdentities(identities);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
        this.setIsSystemDefined(isSystemDefined);
        this.setAuthorizationPolicyType(authorizationPolicyType);
        this.setAssignedUsersCount(assignedUsersCount);
        this.setAssignedUserGroupsCount(assignedUserGroupsCount);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authz.AuthorizationPolicy";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public void setIsSystemDefined(Boolean isSystemDefined) {
        if (this.isSystemDefined == null) {
            this.isSystemDefined = isSystemDefined;
        } else {
            log.warn("Read-only property isSystemDefined already contains a non-null value and cannot be set again");
        }
    }

    public void setAssignedUsersCount(Integer assignedUsersCount) {
        if (this.assignedUsersCount == null) {
            this.assignedUsersCount = assignedUsersCount;
        } else {
            log.warn("Read-only property assignedUsersCount already contains a non-null value and cannot be set again");
        }
    }

    public void setAssignedUserGroupsCount(Integer assignedUserGroupsCount) {
        if (this.assignedUserGroupsCount == null) {
            this.assignedUserGroupsCount = assignedUserGroupsCount;
        } else {
            log.warn("Read-only property assignedUserGroupsCount already contains a non-null value and cannot be set again");
        }
    }

    public static AuthorizationPolicyBuilder AuthorizationPolicyBuilder() {
        return new AuthorizationPolicyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizationPolicy)) {
            return false;
        }
        AuthorizationPolicy other = (AuthorizationPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Boolean this$isSystemDefined = this.getIsSystemDefined();
        Boolean other$isSystemDefined = other.getIsSystemDefined();
        if (this$isSystemDefined == null ? other$isSystemDefined != null : !((Object)this$isSystemDefined).equals(other$isSystemDefined)) {
            return false;
        }
        Integer this$assignedUsersCount = this.getAssignedUsersCount();
        Integer other$assignedUsersCount = other.getAssignedUsersCount();
        if (this$assignedUsersCount == null ? other$assignedUsersCount != null : !((Object)this$assignedUsersCount).equals(other$assignedUsersCount)) {
            return false;
        }
        Integer this$assignedUserGroupsCount = this.getAssignedUserGroupsCount();
        Integer other$assignedUserGroupsCount = other.getAssignedUserGroupsCount();
        if (this$assignedUserGroupsCount == null ? other$assignedUserGroupsCount != null : !((Object)this$assignedUserGroupsCount).equals(other$assignedUserGroupsCount)) {
            return false;
        }
        List<IdentityFilter> this$identities = this.getIdentities();
        List<IdentityFilter> other$identities = other.getIdentities();
        if (this$identities == null ? other$identities != null : !((Object)this$identities).equals(other$identities)) {
            return false;
        }
        AuthorizationPolicyType this$authorizationPolicyType = this.getAuthorizationPolicyType();
        AuthorizationPolicyType other$authorizationPolicyType = other.getAuthorizationPolicyType();
        return !(this$authorizationPolicyType == null ? other$authorizationPolicyType != null : !((Object)((Object)this$authorizationPolicyType)).equals((Object)other$authorizationPolicyType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AuthorizationPolicy;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Boolean $isSystemDefined = this.getIsSystemDefined();
        result = result * 59 + ($isSystemDefined == null ? 43 : ((Object)$isSystemDefined).hashCode());
        Integer $assignedUsersCount = this.getAssignedUsersCount();
        result = result * 59 + ($assignedUsersCount == null ? 43 : ((Object)$assignedUsersCount).hashCode());
        Integer $assignedUserGroupsCount = this.getAssignedUserGroupsCount();
        result = result * 59 + ($assignedUserGroupsCount == null ? 43 : ((Object)$assignedUserGroupsCount).hashCode());
        List<IdentityFilter> $identities = this.getIdentities();
        result = result * 59 + ($identities == null ? 43 : ((Object)$identities).hashCode());
        AuthorizationPolicyType $authorizationPolicyType = this.getAuthorizationPolicyType();
        result = result * 59 + ($authorizationPolicyType == null ? 43 : ((Object)((Object)$authorizationPolicyType)).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Boolean getIsSystemDefined() {
        return this.isSystemDefined;
    }

    public Integer getAssignedUsersCount() {
        return this.assignedUsersCount;
    }

    public Integer getAssignedUserGroupsCount() {
        return this.assignedUserGroupsCount;
    }

    public List<IdentityFilter> getIdentities() {
        return this.identities;
    }

    public AuthorizationPolicyType getAuthorizationPolicyType() {
        return this.authorizationPolicyType;
    }

    @JsonProperty(value="identities")
    public void setIdentities(List<IdentityFilter> identities) {
        this.identities = identities;
    }

    @JsonProperty(value="authorizationPolicyType")
    public void setAuthorizationPolicyType(AuthorizationPolicyType authorizationPolicyType) {
        this.authorizationPolicyType = authorizationPolicyType;
    }

    @Override
    public String toString() {
        return "AuthorizationPolicy(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", isSystemDefined=" + this.getIsSystemDefined() + ", assignedUsersCount=" + this.getAssignedUsersCount() + ", assignedUserGroupsCount=" + this.getAssignedUserGroupsCount() + ", identities=" + this.getIdentities() + ", authorizationPolicyType=" + (Object)((Object)this.getAuthorizationPolicyType()) + ")";
    }

    public static class AuthorizationPolicyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String displayName;
        private String description;
        private String clientName;
        private List<EntityFilter> entities;
        private String role;
        private List<IdentityFilter> identities;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;
        private Boolean isSystemDefined;
        private AuthorizationPolicyType authorizationPolicyType;
        private Integer assignedUsersCount;
        private Integer assignedUserGroupsCount;

        AuthorizationPolicyBuilder() {
        }

        public AuthorizationPolicyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AuthorizationPolicyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public AuthorizationPolicyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public AuthorizationPolicyBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public AuthorizationPolicyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AuthorizationPolicyBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public AuthorizationPolicyBuilder entities(List<EntityFilter> entities) {
            this.entities = entities;
            return this;
        }

        public AuthorizationPolicyBuilder role(String role) {
            this.role = role;
            return this;
        }

        public AuthorizationPolicyBuilder identities(List<IdentityFilter> identities) {
            this.identities = identities;
            return this;
        }

        public AuthorizationPolicyBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public AuthorizationPolicyBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public AuthorizationPolicyBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public AuthorizationPolicyBuilder isSystemDefined(Boolean isSystemDefined) {
            this.isSystemDefined = isSystemDefined;
            return this;
        }

        public AuthorizationPolicyBuilder authorizationPolicyType(AuthorizationPolicyType authorizationPolicyType) {
            this.authorizationPolicyType = authorizationPolicyType;
            return this;
        }

        public AuthorizationPolicyBuilder assignedUsersCount(Integer assignedUsersCount) {
            this.assignedUsersCount = assignedUsersCount;
            return this;
        }

        public AuthorizationPolicyBuilder assignedUserGroupsCount(Integer assignedUserGroupsCount) {
            this.assignedUserGroupsCount = assignedUserGroupsCount;
            return this;
        }

        public AuthorizationPolicy build() {
            return new AuthorizationPolicy(this.tenantId, this.extId, this.links, this.displayName, this.description, this.clientName, this.entities, this.role, this.identities, this.createdTime, this.lastUpdatedTime, this.createdBy, this.isSystemDefined, this.authorizationPolicyType, this.assignedUsersCount, this.assignedUserGroupsCount);
        }

        public String toString() {
            return "AuthorizationPolicy.AuthorizationPolicyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", displayName=" + this.displayName + ", description=" + this.description + ", clientName=" + this.clientName + ", entities=" + this.entities + ", role=" + this.role + ", identities=" + this.identities + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ", isSystemDefined=" + this.isSystemDefined + ", authorizationPolicyType=" + (Object)((Object)this.authorizationPolicyType) + ", assignedUsersCount=" + this.assignedUsersCount + ", assignedUserGroupsCount=" + this.assignedUserGroupsCount + ")";
        }
    }
}

