/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authn.CreationType;
import com.nutanix.dp1.iam.iam.v4.authn.UserType;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretKeyResponse
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(SecretKeyResponse.class);
    private String userId = null;
    @JsonProperty(value="secretAccessKey")
    public String secretAccessKey = null;
    @Pattern(regexp="^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$")
    @Size(max=255)
    @JsonProperty(value="emailId")
    public @Pattern(regexp="^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$") @Size(max=255) String emailId = null;
    @JsonProperty(value="userType")
    public UserType userType = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="tenantId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String tenantId = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="idpId")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String idpId = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="username")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String username = null;
    @JsonProperty(value="creationType")
    public CreationType creationType = null;
    @JsonProperty(value="customClaims")
    public Map<String, String> customClaims = null;
    @Size(min=3, max=255)
    @JsonProperty(value="assignedTo")
    public @Size(min=3, max=255) String assignedTo = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public SecretKeyResponse() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public SecretKeyResponse(String secretAccessKey, String emailId, String userId, UserType userType, String tenantId, String idpId, String username, CreationType creationType, Map<String, String> customClaims, String assignedTo) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setSecretAccessKey(secretAccessKey);
        this.setEmailId(emailId);
        this.setUserId(userId);
        this.setUserType(userType);
        this.setTenantId(tenantId);
        this.setIdpId(idpId);
        this.setUsername(username);
        this.setCreationType(creationType);
        this.setCustomClaims(customClaims);
        this.setAssignedTo(assignedTo);
    }

    protected String initialize$objectType() {
        return "iam.v4.authn.SecretKeyResponse";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setUserId(String userId) {
        if (this.userId == null) {
            this.userId = userId;
        } else {
            log.warn("Read-only property userId already contains a non-null value and cannot be set again");
        }
    }

    public static SecretKeyResponseBuilder SecretKeyResponseBuilder() {
        return new SecretKeyResponseBuilder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public String getUsername() {
        return this.username;
    }

    public CreationType getCreationType() {
        return this.creationType;
    }

    public Map<String, String> getCustomClaims() {
        return this.customClaims;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    @JsonProperty(value="secretAccessKey")
    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    @JsonProperty(value="emailId")
    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    @JsonProperty(value="userType")
    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="idpId")
    public void setIdpId(String idpId) {
        this.idpId = idpId;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(value="creationType")
    public void setCreationType(CreationType creationType) {
        this.creationType = creationType;
    }

    @JsonProperty(value="customClaims")
    public void setCustomClaims(Map<String, String> customClaims) {
        this.customClaims = customClaims;
    }

    @JsonProperty(value="assignedTo")
    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretKeyResponse)) {
            return false;
        }
        SecretKeyResponse other = (SecretKeyResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$secretAccessKey = this.getSecretAccessKey();
        String other$secretAccessKey = other.getSecretAccessKey();
        if (this$secretAccessKey == null ? other$secretAccessKey != null : !this$secretAccessKey.equals(other$secretAccessKey)) {
            return false;
        }
        String this$emailId = this.getEmailId();
        String other$emailId = other.getEmailId();
        if (this$emailId == null ? other$emailId != null : !this$emailId.equals(other$emailId)) {
            return false;
        }
        UserType this$userType = this.getUserType();
        UserType other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)((Object)this$userType)).equals((Object)other$userType)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$idpId = this.getIdpId();
        String other$idpId = other.getIdpId();
        if (this$idpId == null ? other$idpId != null : !this$idpId.equals(other$idpId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        CreationType this$creationType = this.getCreationType();
        CreationType other$creationType = other.getCreationType();
        if (this$creationType == null ? other$creationType != null : !((Object)((Object)this$creationType)).equals((Object)other$creationType)) {
            return false;
        }
        Map<String, String> this$customClaims = this.getCustomClaims();
        Map<String, String> other$customClaims = other.getCustomClaims();
        if (this$customClaims == null ? other$customClaims != null : !((Object)this$customClaims).equals(other$customClaims)) {
            return false;
        }
        String this$assignedTo = this.getAssignedTo();
        String other$assignedTo = other.getAssignedTo();
        return !(this$assignedTo == null ? other$assignedTo != null : !this$assignedTo.equals(other$assignedTo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecretKeyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $secretAccessKey = this.getSecretAccessKey();
        result = result * 59 + ($secretAccessKey == null ? 43 : $secretAccessKey.hashCode());
        String $emailId = this.getEmailId();
        result = result * 59 + ($emailId == null ? 43 : $emailId.hashCode());
        UserType $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)((Object)$userType)).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $idpId = this.getIdpId();
        result = result * 59 + ($idpId == null ? 43 : $idpId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        CreationType $creationType = this.getCreationType();
        result = result * 59 + ($creationType == null ? 43 : ((Object)((Object)$creationType)).hashCode());
        Map<String, String> $customClaims = this.getCustomClaims();
        result = result * 59 + ($customClaims == null ? 43 : ((Object)$customClaims).hashCode());
        String $assignedTo = this.getAssignedTo();
        result = result * 59 + ($assignedTo == null ? 43 : $assignedTo.hashCode());
        return result;
    }

    public String toString() {
        return "SecretKeyResponse(userId=" + this.getUserId() + ", secretAccessKey=" + this.getSecretAccessKey() + ", emailId=" + this.getEmailId() + ", userType=" + (Object)((Object)this.getUserType()) + ", tenantId=" + this.getTenantId() + ", idpId=" + this.getIdpId() + ", username=" + this.getUsername() + ", creationType=" + (Object)((Object)this.getCreationType()) + ", customClaims=" + this.getCustomClaims() + ", assignedTo=" + this.getAssignedTo() + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class SecretKeyResponseBuilder {
        private String secretAccessKey;
        private String emailId;
        private String userId;
        private UserType userType;
        private String tenantId;
        private String idpId;
        private String username;
        private CreationType creationType;
        private Map<String, String> customClaims;
        private String assignedTo;

        SecretKeyResponseBuilder() {
        }

        public SecretKeyResponseBuilder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public SecretKeyResponseBuilder emailId(String emailId) {
            this.emailId = emailId;
            return this;
        }

        public SecretKeyResponseBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public SecretKeyResponseBuilder userType(UserType userType) {
            this.userType = userType;
            return this;
        }

        public SecretKeyResponseBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public SecretKeyResponseBuilder idpId(String idpId) {
            this.idpId = idpId;
            return this;
        }

        public SecretKeyResponseBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SecretKeyResponseBuilder creationType(CreationType creationType) {
            this.creationType = creationType;
            return this;
        }

        public SecretKeyResponseBuilder customClaims(Map<String, String> customClaims) {
            this.customClaims = customClaims;
            return this;
        }

        public SecretKeyResponseBuilder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        public SecretKeyResponse build() {
            return new SecretKeyResponse(this.secretAccessKey, this.emailId, this.userId, this.userType, this.tenantId, this.idpId, this.username, this.creationType, this.customClaims, this.assignedTo);
        }

        public String toString() {
            return "SecretKeyResponse.SecretKeyResponseBuilder(secretAccessKey=" + this.secretAccessKey + ", emailId=" + this.emailId + ", userId=" + this.userId + ", userType=" + (Object)((Object)this.userType) + ", tenantId=" + this.tenantId + ", idpId=" + this.idpId + ", username=" + this.username + ", creationType=" + (Object)((Object)this.creationType) + ", customClaims=" + this.customClaims + ", assignedTo=" + this.assignedTo + ")";
        }
    }
}

