/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import java.util.HashMap;
import java.util.Map;

public enum SQLState {
    NUMERIC_VALUE_OUT_OF_RANGE("22003"),
    COMMUNICATION_LINK_ERROR("08S01"),
    INVALID_PARAMETER_VALUE("22023"),
    SYNTAX_ERROR("42000", -1),
    FEATURE_NOT_YET_IMPLEMENTED("0A000", -2),
    BUG_CHECK("58000", -3),
    COMPILE_ERROR("42000", -4),
    RUNTIME_ERROR("58000", -5),
    IO_ERROR("08000", -6),
    NETWORK_ERROR("08000", -7),
    CONVERSION_ERROR("22000", -8),
    TRUNCATION_ERROR("22000", -9),
    CONNECTION_ERROR("08000", -10),
    DDL_ERROR("42000", -11),
    APPLICATION_ERROR("58000", -12),
    SECURITY_ERROR("58000", -13),
    DATABASE_CORRUPTION("58000", -14),
    VERSION_ERROR("58000", -15),
    LICENSE_ERROR("58000", -16),
    INTERNAL_ERROR("58000", -17),
    DEBUG_ERROR("58000", -18),
    LOST_BLOB("22000", -19),
    INCONSISTENT_BLOB("22000", -20),
    DELETED_BLOB("22000", -21),
    LOG_ERROR("58000", -22),
    DATABASE_DAMAGED("58000", -23),
    UPDATE_CONFLICT("40002", -24),
    NO_SUCH_TABLE("42000", -25),
    INDEX_OVERFLOW("58000", -26),
    UNIQUE_DUPLICATE("23000", -27),
    UNCOMMITTED_UPDATES("58000", -28),
    DEADLOCK("40001", -29),
    OUT_OF_MEMORY_ERROR("58000", -30),
    OUT_OF_RECORD_MEMORY_ERROR("58000", -31),
    LOCK_TIMEOUT("58000", -32),
    PLATFORM_ERROR("58000", -36),
    NO_SCHEMA("58000", -37),
    CONFIGURATION_ERROR("58000", -38),
    READ_ONLY_ERROR("58000", -39),
    NO_GENERATED_KEYS("58000", -40),
    THROWN_EXCEPTION("58000", -41),
    INVALID_TRANSACTION_ISOLATION("01000", -42),
    UNSUPPORTED_TRANSACTION_ISOLATION("0A000", -43),
    INVALID_UTF8("58000", -44),
    CONSTRAINT_ERROR("23001", -45),
    UPDATE_ERROR("58000", -46),
    I18N_ERROR("58000", -47),
    OPERATION_KILLED("HY008", -48),
    INVALID_STATEMENT("58000", -49),
    IS_SHUTDOWN("58000", -50),
    IN_QUOTED_STRING("58000", -51),
    BATCH_UPDATE_ERROR("58000", -52),
    JAVA_ERROR("58000", -53),
    INVALID_FIELD("58000", -54),
    INVALID_INDEX_NULL("58000", -55),
    INVALID_OPERATION("58000", -56),
    INVALID_STATISTICS("58000", -57),
    INVALID_GENERATOR("58000", -58),
    OPERATION_TIMEOUT("HYT00", -59),
    NO_SUCH_INDEX("42S12", -60),
    NO_SUCH_SEQUENCE("HY101", -61),
    XAER_PROTO("HY102", -62),
    UNKNOWN_ERROR("HYZZZ", -63),
    TRANSACTIONAL_LOCK_ERROR("40003", -64),
    TRANSACTION_STATE_UNKNOWN("08007", -65),
    INVALID_TIMEZONE_DISPLACEMENT_VALUE("22009", -66),
    INVALID_JSON_TEXT("22032", -67),
    SEQUENCE_GENERATE_LIMIT_EXCEEDED("2200H", -68),
    NO_SQL_JSON_ITEM("22035", -69);

    private static final Map<Integer, SQLState> SQL_STATES;
    private int code;
    private String state;
    private String stateClass;

    private SQLState(String state) {
        this.state = state;
        this.stateClass = state.substring(0, 2);
    }

    private SQLState(String state, int code) {
        this.state = state;
        this.stateClass = state.substring(0, 2);
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getState() {
        return this.state;
    }

    public String getStateClass() {
        return this.stateClass;
    }

    public static int getCode(SQLState sqlState) {
        return sqlState != null ? sqlState.getCode() : 0;
    }

    public static String getState(SQLState sqlState) {
        return sqlState != null ? sqlState.getState() : null;
    }

    public static String getState(int code) {
        return SQLState.getState(SQLState.getSQLState(code));
    }

    public static SQLState getSQLState(int code) {
        SQLState result = SQL_STATES.get(code);
        return result == null ? UNKNOWN_ERROR : result;
    }

    static {
        SQL_STATES = new HashMap<Integer, SQLState>();
        for (SQLState sqlState : SQLState.values()) {
            if (sqlState.getCode() == 0) continue;
            SQL_STATES.put(sqlState.getCode(), sqlState);
        }
    }
}

