/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.impl.util.ByteUtils;
import com.nuodb.impl.util.StreamUtils;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.jdbc.Blob;
import com.nuodb.jdbc.Clob;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemEncodedStream;
import com.nuodb.jdbc.RemParameterMetaData;
import com.nuodb.jdbc.RemResultSetMetaData;
import com.nuodb.jdbc.RemStatement;
import com.nuodb.jdbc.SQLException;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.SQLStateException;
import com.nuodb.jdbc.Utils;
import com.nuodb.jdbc.Value;
import com.nuodb.jdbc.ValueArray;
import com.nuodb.jdbc.ValueBlob;
import com.nuodb.jdbc.ValueBoolean;
import com.nuodb.jdbc.ValueByte;
import com.nuodb.jdbc.ValueBytes;
import com.nuodb.jdbc.ValueClob;
import com.nuodb.jdbc.ValueDate;
import com.nuodb.jdbc.ValueDouble;
import com.nuodb.jdbc.ValueInt;
import com.nuodb.jdbc.ValueLong;
import com.nuodb.jdbc.ValueNull;
import com.nuodb.jdbc.ValueNumber;
import com.nuodb.jdbc.ValueShort;
import com.nuodb.jdbc.ValueString;
import com.nuodb.jdbc.ValueTime;
import com.nuodb.jdbc.ValueTimestamp;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

public class RemPreparedStatement
extends RemStatement
implements PreparedStatement {
    int numberParameters;
    int parametersCapacity;
    int batchCount;
    boolean generatingKeys;
    Value[] parameters;
    EncodedDataStream batchMessage;
    String[] columnNames;
    RemResultSetMetaData metaData;
    String sqlString;
    int[] columnIndexes;
    Integer resultSetHoldability;
    static final int SubTypePrepare = 0;
    static final int SubTypePrepareHold = 1;
    static final int SubTypePrepareKeys = 2;
    static final int SubTypePrepareKeyIds = 3;
    static final int SubTypePrepareKeyNames = 4;
    static final int SubTypeExecute = 5;
    static final int SubTypeExecuteQuery = 6;
    static final int SubTypeExecuteUpdate = 7;
    int prepareSubType;
    static final int UNPREPARED_STATEMENT_HANDLE = -1;

    RemPreparedStatement(RemConnection connect, int statementHandle, int count, boolean genKeys) {
        super(connect, statementHandle);
        this.numberParameters = count;
        this.parameters = new Value[this.numberParameters];
        this.generatingKeys = genKeys;
        this.metaData = null;
    }

    RemPreparedStatement(RemConnection connect, String sql, boolean genKeys, int[] columnIndexes, String[] columnNames, Integer resultSetHoldability) {
        super(connect, -1);
        this.sqlString = sql;
        this.generatingKeys = genKeys;
        if (genKeys) {
            if (columnIndexes != null) {
                this.columnIndexes = columnIndexes;
                this.prepareSubType = 3;
            } else if (columnNames != null) {
                this.columnNames = columnNames;
                this.prepareSubType = 4;
            } else {
                this.prepareSubType = 2;
            }
        } else if (resultSetHoldability != null) {
            this.resultSetHoldability = resultSetHoldability;
            this.prepareSubType = 1;
        } else {
            this.prepareSubType = 0;
        }
        this.numberParameters = 0;
        this.parametersCapacity = 32;
        this.parameters = new Value[this.parametersCapacity];
    }

    private boolean isUnprepared() {
        return this.handle == -1;
    }

    private void ensurePrepared() throws java.sql.SQLException {
        if (!this.isUnprepared()) {
            return;
        }
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        switch (this.prepareSubType) {
            case 0: {
                dataStream.startMessage(9);
                break;
            }
            case 1: {
                dataStream.startMessage(128);
                dataStream.encodeInt(1003);
                dataStream.encodeInt(1007);
                dataStream.encodeInt(this.resultSetHoldability);
                break;
            }
            case 2: {
                dataStream.startMessage(88);
                dataStream.encodeInt(1);
                break;
            }
            case 3: {
                dataStream.startMessage(90);
                dataStream.encodeInt(this.columnIndexes.length);
                for (int id : this.columnIndexes) {
                    dataStream.encodeInt(id);
                }
                break;
            }
            case 4: {
                dataStream.startMessage(89);
                dataStream.encodeInt(this.columnNames.length);
                for (String name : this.columnNames) {
                    dataStream.encodeString(name);
                }
                break;
            }
        }
        dataStream.encodeString(this.sqlString);
        this.communicateWithServer(dataStream);
        this.handle = dataStream.getInt();
        int n = dataStream.getInt();
        this.updateNumberParameters(n);
        boolean hasMetaData = dataStream.getBoolean();
        if (hasMetaData) {
            this.metaData = new RemResultSetMetaData(dataStream);
        }
    }

    @Override
    public void addBatch() throws java.sql.SQLException {
        this.ensurePrepared();
        if (this.batchMessage == null) {
            this.checkOpen();
            this.batchCount = 0;
            this.batchMessage = new RemEncodedStream(this.connection.protocolVersion);
            this.batchMessage.startMessage(84);
            this.encodeLastTxnIds(this.batchMessage);
            this.batchMessage.encodeInt(this.handle);
        }
        this.putParameters(this.batchMessage, null);
        ++this.batchCount;
    }

    @Override
    public void clearBatch() throws java.sql.SQLException {
        this.batchCount = 0;
        this.batchMessage = null;
    }

    @Override
    public ResultSet getResultSet() throws java.sql.SQLException {
        if (this.isUnprepared()) {
            return null;
        }
        return super.getResultSet();
    }

    @Override
    public void clearParameters() throws java.sql.SQLException {
        this.parameters = this.isUnprepared() ? new Value[this.parametersCapacity] : new Value[this.numberParameters];
    }

    @Override
    public boolean execute(String sql) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public ResultSet executeQuery(String arg0) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws java.sql.SQLException {
        throw new java.sql.SQLException("Cannot execute PreparedStatement with SQL parameter");
    }

    @Override
    public boolean execute() throws java.sql.SQLException {
        this.checkOpen();
        if (this.isUnprepared()) {
            return this.prepareAndExecute();
        }
        this.lastResultSet = null;
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(22);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        this.putParameters(dataStream, null);
        this.communicateWithServer(dataStream);
        boolean ret = dataStream.getInt() != 0;
        this.updateRecordsUpdated(dataStream);
        this.updateTimeZone(dataStream);
        this.updateLastCommitInfo(dataStream, this.generatingKeys);
        return ret;
    }

    private void prepareAndExecuteCommon(EncodedDataStream dataStream) throws java.sql.SQLException {
        dataStream.encodeInt(this.prepareSubType);
        dataStream.encodeString(this.sqlString);
        switch (this.prepareSubType) {
            case 3: {
                dataStream.encodeInt(this.columnIndexes.length);
                for (int id : this.columnIndexes) {
                    dataStream.encodeInt(id);
                }
                break;
            }
            case 4: {
                dataStream.encodeInt(this.columnNames.length);
                for (String name : this.columnNames) {
                    dataStream.encodeString(name);
                }
                break;
            }
            case 1: {
                dataStream.encodeInt(this.resultSetHoldability);
                break;
            }
        }
        dataStream.encodeLong(this.getQueryTimeoutMicros());
        dataStream.encodeInt(this.fetchSize);
        this.encodeLastTxnIds(dataStream);
        this.putParameters(dataStream, null);
        this.communicateWithServer(dataStream);
        this.handle = dataStream.getInt();
        int n = dataStream.getInt();
        this.updateNumberParameters(n);
    }

    private boolean prepareAndExecute() throws java.sql.SQLException {
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(25);
        dataStream.encodeInt(5);
        this.prepareAndExecuteCommon(dataStream);
        boolean ret = dataStream.getInt() != 0;
        this.updateRecordsUpdated(dataStream);
        this.updateTimeZone(dataStream);
        this.updateLastCommitInfo(dataStream, this.generatingKeys);
        return ret;
    }

    private void updateNumberParameters(int newValue) throws java.sql.SQLException {
        if (newValue < this.numberParameters) {
            throw new java.sql.SQLException("Parameter number mismatch");
        }
        this.numberParameters = newValue;
        if (this.numberParameters > this.parametersCapacity) {
            Value[] tempParams = this.parameters;
            this.parameters = new Value[this.numberParameters];
            System.arraycopy(tempParams, 0, this.parameters, 0, this.numberParameters);
        }
    }

    private ResultSet prepareAndExecuteQuery() throws java.sql.SQLException {
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(25);
        dataStream.encodeInt(6);
        this.prepareAndExecuteCommon(dataStream);
        this.metaData = new RemResultSetMetaData(dataStream);
        this.lastResultSet = this.createResultSet(dataStream, true);
        this.lastResultSet.setMetaData(this.metaData);
        this.columnNames = this.lastResultSet.getColumnNames();
        return this.lastResultSet;
    }

    public int prepareAndExecuteUpdate() throws java.sql.SQLException {
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(25);
        dataStream.encodeInt(7);
        this.prepareAndExecuteCommon(dataStream);
        this.updateRecordsUpdated(dataStream);
        this.updateTimeZone(dataStream);
        this.updateLastCommitInfo(dataStream, this.generatingKeys);
        return this.updateCount;
    }

    @Override
    public void setCursorName(String cursorName) throws java.sql.SQLException {
        this.ensurePrepared();
        super.setCursorName(cursorName);
    }

    @Override
    public void setQueryTimeout(int seconds) throws java.sql.SQLException {
        long micros = (long)seconds * 1000000L;
        if (this.isUnprepared()) {
            this.queryTimeoutMicros = micros;
        } else {
            this.setQueryTimeoutMicros(micros);
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws java.sql.SQLException {
        if (!this.isUnprepared()) {
            super.setFetchSize(fetchSize);
            return;
        }
        if (fetchSize < 0) {
            throw new SQLException("Fetch size must be equal to or greater than 0", SQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public ResultSet executeQuery() throws java.sql.SQLException {
        this.checkOpen();
        if (this.isUnprepared()) {
            return this.prepareAndExecuteQuery();
        }
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(23);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        this.putParameters(dataStream, null);
        boolean readColumnNames = true;
        if (this.columnNames != null) {
            dataStream.encodeInt(1);
            readColumnNames = false;
        } else {
            dataStream.encodeInt(0);
        }
        this.communicateWithServer(dataStream);
        this.lastResultSet = this.createResultSet(dataStream, readColumnNames);
        this.columnNames = this.lastResultSet.getColumnNames();
        return this.lastResultSet;
    }

    public String analyzeStatement(int mask) throws java.sql.SQLException {
        this.checkOpen();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(71);
        dataStream.encodeInt(this.handle);
        dataStream.encodeInt(mask);
        this.communicateWithServer(dataStream);
        return dataStream.getString();
    }

    @Override
    public int executeUpdate() throws java.sql.SQLException {
        this.checkOpen();
        if (this.isUnprepared()) {
            return this.prepareAndExecuteUpdate();
        }
        this.lastResultSet = null;
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(24);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        this.putParameters(dataStream, null);
        this.communicateWithServer(dataStream);
        this.updateRecordsUpdated(dataStream);
        this.updateTimeZone(dataStream);
        this.updateLastCommitInfo(dataStream, this.generatingKeys);
        return this.updateCount;
    }

    @Override
    public int[] executeBatch() throws java.sql.SQLException {
        this.checkOpen();
        int[] batchResults = new int[Math.max(1, this.batchCount)];
        if (this.batchMessage == null) {
            return batchResults;
        }
        this.generatedKeys = null;
        this.batchMessage.encodeInt(-1);
        this.batchMessage.encodeInt(this.batchCount);
        this.communicateWithServer(this.batchMessage);
        String batchUpdateMessage = null;
        SQLState batchUpdateState = null;
        java.sql.SQLException batchUpdateException = null;
        for (int n = 0; n < this.batchCount; ++n) {
            batchResults[n] = this.batchMessage.getInt();
            if (batchResults[n] != -3) continue;
            int stateCode = this.batchMessage.getInt();
            SQLState state = SQLState.getSQLState(stateCode);
            String message = this.batchMessage.getString();
            java.sql.SQLException exception = SQLStateException.fromStateClass(state.getStateClass()).create(message, state.getState(), stateCode);
            if (batchUpdateException == null) {
                batchUpdateMessage = message;
                batchUpdateState = state;
                batchUpdateException = exception;
                continue;
            }
            batchUpdateException.setNextException(exception);
        }
        this.updateTimeZone(this.batchMessage);
        this.updateLastCommitInfo(this.batchMessage, this.generatingKeys);
        this.batchMessage = null;
        if (batchUpdateException != null) {
            BatchUpdateException exception = new BatchUpdateException(batchUpdateMessage, batchUpdateState.getState(), batchUpdateState.getCode(), batchResults);
            exception.setNextException(batchUpdateException);
            throw exception;
        }
        return batchResults;
    }

    @Override
    public ResultSetMetaData getMetaData() throws java.sql.SQLException {
        this.checkOpen();
        this.ensurePrepared();
        if (this.lastResultSet != null) {
            return this.lastResultSet.getMetaData();
        }
        return this.metaData;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws java.sql.SQLException {
        this.checkOpen();
        this.ensurePrepared();
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(85);
        dataStream.encodeInt(this.handle);
        this.communicateWithServer(dataStream);
        return new RemParameterMetaData(dataStream);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueArray(x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws java.sql.SQLException {
        this.setCharacterStream(parameterIndex, (Reader)(x == null ? null : new InputStreamReader(x)), Integer.MAX_VALUE);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws java.sql.SQLException {
        this.setCharacterStream(parameterIndex, (Reader)(x == null ? null : new InputStreamReader(x)), length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws java.sql.SQLException {
        this.setCharacterStream(parameterIndex, (Reader)(x == null ? null : new InputStreamReader(x)), length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueNumber(x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws java.sql.SQLException {
        this.setBinaryStream(parameterIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws java.sql.SQLException {
        try {
            this.setBytes(parameterIndex, x == null ? null : ByteUtils.drainStream(x, 512, length));
        }
        catch (IOException e) {
            throw new java.sql.SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws java.sql.SQLException {
        Clob.checkLongValue(length, "parameter: " + parameterIndex);
        try {
            this.setBytes(parameterIndex, x == null ? null : ByteUtils.drainStream(x, 512, (int)length));
        }
        catch (IOException e) {
            throw new java.sql.SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, java.sql.Blob x) throws java.sql.SQLException {
        this.setValue(parameterIndex, x == null ? new ValueNull() : new ValueBlob(x));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws java.sql.SQLException {
        this.setBlob(parameterIndex, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws java.sql.SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new java.sql.SQLException(MessageFormat.format("length {0} is greater than max supported value of {1}", length, Integer.MAX_VALUE));
        }
        try {
            Blob b = this.connection.createBlob();
            b.setBytes(1L, ByteUtils.drainStream(inputStream, 1024, (int)length));
            this.setBlob(parameterIndex, b);
        }
        catch (IOException e) {
            throw new java.sql.SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueBoolean(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueByte(x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueBytes(x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws java.sql.SQLException {
        this.setCharacterStream(parameterIndex, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws java.sql.SQLException {
        try {
            this.setString(parameterIndex, reader == null ? null : StringUtils.drainStream(reader, length).toString());
        }
        catch (IOException e) {
            throw new java.sql.SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws java.sql.SQLException {
        Clob.checkLongValue(length, "parameter: " + parameterIndex);
        try {
            this.setString(parameterIndex, reader == null ? null : StringUtils.drainStream(reader, (int)length).toString());
        }
        catch (IOException e) {
            throw new java.sql.SQLException("on parameter: " + parameterIndex, e);
        }
    }

    @Override
    public void setClob(int parameterIndex, java.sql.Clob x) throws java.sql.SQLException {
        this.setValue(parameterIndex, x == null ? new ValueNull() : new ValueClob(x));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws java.sql.SQLException {
        Clob clob = this.connection.createClob();
        try {
            clob.setString(1L, StreamUtils.drain(reader));
        }
        catch (IOException e) {
            throw new java.sql.SQLException("Reader problem for parameter: " + parameterIndex, e);
        }
        this.setClob(parameterIndex, clob);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws java.sql.SQLException {
        Clob clob = this.connection.createClob();
        try {
            clob.setString(1L, StreamUtils.drain(reader, length));
        }
        catch (IOException e) {
            throw new java.sql.SQLException("Reader problem for parameter: " + parameterIndex, e);
        }
        this.setClob(parameterIndex, clob);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueDate(x));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws java.sql.SQLException {
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueDouble(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueDouble(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueInt(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueLong(x));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueNull());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws java.sql.SQLException {
        if (x == null) {
            this.setObject(parameterIndex, x, 0);
        } else if (x instanceof String) {
            this.setObject(parameterIndex, x, 12);
        } else if (x instanceof Integer) {
            this.setObject(parameterIndex, x, 4);
        } else if (x instanceof Long) {
            this.setObject(parameterIndex, x, -5);
        } else if (x instanceof BigDecimal) {
            this.setObject(parameterIndex, x, 2);
        } else if (x instanceof Boolean) {
            this.setObject(parameterIndex, x, 16);
        } else if (x instanceof Byte) {
            this.setObject(parameterIndex, x, -6);
        } else if (x instanceof Short) {
            this.setObject(parameterIndex, x, 5);
        } else if (x instanceof Float) {
            this.setObject(parameterIndex, x, 7);
        } else if (x instanceof Double) {
            this.setObject(parameterIndex, x, 8);
        } else if (x instanceof byte[]) {
            this.setObject(parameterIndex, x, -2);
        } else if (x instanceof Date) {
            this.setObject(parameterIndex, x, 91);
        } else if (x instanceof Time) {
            this.setObject(parameterIndex, x, 92);
        } else if (x instanceof Timestamp) {
            this.setObject(parameterIndex, x, 93);
        } else if (x instanceof java.sql.Clob) {
            this.setObject(parameterIndex, x, 2005);
        } else if (x instanceof java.sql.Blob) {
            this.setObject(parameterIndex, x, 2004);
        } else if (x instanceof Array) {
            this.setObject(parameterIndex, x, 2003);
        } else if (x instanceof Struct) {
            this.setObject(parameterIndex, x, 2002);
        } else if (x instanceof Ref) {
            this.setObject(parameterIndex, x, 2006);
        } else if (x instanceof URL) {
            this.setObject(parameterIndex, x, 70);
        } else if (x instanceof Class) {
            this.setObject(parameterIndex, x, 2000);
        } else if (x instanceof RowId) {
            this.setObject(parameterIndex, x, -8);
        } else if (x instanceof NClob) {
            this.setObject(parameterIndex, x, 2011);
        } else if (x instanceof SQLXML) {
            this.setObject(parameterIndex, x, 2009);
        } else if (x instanceof Date) {
            this.setObject(parameterIndex, x, 91);
        } else {
            this.setObject(parameterIndex, x, 1111);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws java.sql.SQLException {
        this.setObject(parameterIndex, x, targetSqlType, null, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws java.sql.SQLException {
        this.setObject(parameterIndex, x, targetSqlType, scaleOrLength, Long.valueOf(scaleOrLength));
    }

    void setObject(int parameterIndex, Object x, int targetSqlType, Integer scale, Long length) throws java.sql.SQLException {
        if (x == null) {
            targetSqlType = 0;
        }
        switch (targetSqlType) {
            case -5: {
                this.setValue(parameterIndex, new ValueLong(x));
                break;
            }
            case -3: 
            case -2: {
                this.setValue(parameterIndex, new ValueBytes(x));
                break;
            }
            case 2004: {
                this.setValue(parameterIndex, new ValueBlob((java.sql.Blob)x));
                break;
            }
            case 16: {
                this.setValue(parameterIndex, new ValueBoolean(x));
                break;
            }
            case 2005: {
                this.setValue(parameterIndex, new ValueClob((java.sql.Clob)x));
                break;
            }
            case 91: {
                this.setValue(parameterIndex, new ValueDate(x));
                break;
            }
            case 93: {
                this.setValue(parameterIndex, new ValueTimestamp(x));
                break;
            }
            case 92: {
                this.setValue(parameterIndex, new ValueTime(x));
                break;
            }
            case 2: 
            case 3: {
                this.setValue(parameterIndex, new ValueNumber(x, scale));
                break;
            }
            case 7: 
            case 8: {
                this.setValue(parameterIndex, new ValueDouble(x));
                break;
            }
            case 6: {
                this.setValue(parameterIndex, new ValueDouble(x));
                break;
            }
            case 4: {
                this.setValue(parameterIndex, new ValueInt(x));
                break;
            }
            case 5: {
                this.setValue(parameterIndex, new ValueShort(x));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setValue(parameterIndex, new ValueString(x));
                break;
            }
            case 0: {
                this.setValue(parameterIndex, new ValueNull());
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException(String.format("setObject() with type %d is not supported", targetSqlType));
            }
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueShort(x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueString(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueTime(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws java.sql.SQLException {
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws java.sql.SQLException {
        this.setValue(parameterIndex, new ValueTimestamp(x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws java.sql.SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws java.sql.SQLException {
        Utils.notYetImplemented();
    }

    void setValue(int parameterIndex, Value value) throws java.sql.SQLException {
        if (parameterIndex < 1) {
            throw new java.sql.SQLException("invalid parameter index (" + String.valueOf(parameterIndex) + ")");
        }
        if (parameterIndex > this.numberParameters) {
            if (this.isUnprepared()) {
                if (parameterIndex > this.parametersCapacity) {
                    while (parameterIndex > this.parametersCapacity) {
                        this.parametersCapacity *= 2;
                    }
                    Value[] tempParams = this.parameters;
                    this.parameters = new Value[this.parametersCapacity];
                    System.arraycopy(tempParams, 0, this.parameters, 0, this.numberParameters);
                }
                this.numberParameters = parameterIndex;
            } else {
                throw new java.sql.SQLException("invalid parameter index (" + String.valueOf(parameterIndex) + ")");
            }
        }
        this.parameters[parameterIndex - 1] = value;
    }

    void putParameters(EncodedDataStream dataStream, int[] directions) throws java.sql.SQLException {
        dataStream.encodeInt(this.numberParameters);
        for (int n = 0; n < this.numberParameters; ++n) {
            if (directions != null && this.parameters[n] == null && directions[n] == 2) {
                dataStream.encodeNull();
                continue;
            }
            if (this.parameters[n] == null) {
                throw new java.sql.SQLException("invalid number of parameters provided");
            }
            this.parameters[n].encodeValue(dataStream);
        }
    }
}

