/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import java.sql.Time;
import java.util.Calendar;
import java.util.Formatter;
import java.util.TimeZone;

public class NuoDBTime
extends Time {
    private int nanos;
    private static final ThreadLocal<Calendar> CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    NuoDBTime(long inMillis, int nanos) {
        super(inMillis);
        this.nanos = nanos;
    }

    int getNanos() {
        return this.nanos;
    }

    long getTimeInNanos() {
        return this.getTime() / 1000L + (long)this.nanos;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public static Calendar getCalendar() {
        return CALENDAR.get();
    }

    public String toString(TimeZone tz) {
        Calendar c = CALENDAR.get();
        c.setTimeZone(tz == null ? TimeZone.getDefault() : tz);
        c.setTimeInMillis(this.getTime());
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        StringBuilder sb = new StringBuilder(20);
        Formatter f = new Formatter(sb);
        if (this.nanos > 0) {
            int pow = 1;
            int width = 9;
            while (this.nanos % (pow * 10) == 0) {
                --width;
                pow *= 10;
            }
            String formatString = "%02d:%02d:%02d.%0" + width + "d";
            f.format(formatString, hour, minute, second, this.nanos / pow);
        } else {
            f.format("%02d:%02d:%02d", hour, minute, second);
        }
        String t = f.toString();
        return t;
    }
}

