/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.impl.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;
import java.text.MessageFormat;

public class Clob
implements java.sql.Clob {
    String value;
    ClobOutputStream outputStream = null;
    ClobWriter writer = null;

    Clob() {
    }

    Clob(String value) {
        this.value = value;
    }

    Clob(java.sql.Clob clob) throws SQLException {
        if (clob == null) {
            return;
        }
        long length = clob.length();
        if (length > 0L) {
            this.value = clob.getSubString(1L, (int)length);
        } else if (length == 0L) {
            this.value = "";
        }
    }

    public boolean hasData() {
        return this.value != null;
    }

    public byte[] getBytes() {
        if (this.value == null) {
            return null;
        }
        return this.value.getBytes();
    }

    public String getString() {
        return this.value;
    }

    @Override
    public long length() throws SQLException {
        if (this.value == null) {
            return -1L;
        }
        return this.value.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.value == null) {
            return null;
        }
        if (pos == 0L) {
            throw new SQLException("The first byte in the CLOB is at position 1");
        }
        if (--pos == 0L && length == this.value.length()) {
            return this.value;
        }
        Clob.checkLongValue(pos, "position");
        return this.value.substring((int)pos, (int)pos + length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.value == null ? "" : this.value);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ByteArrayInputStream(this.value == null ? new byte[]{} : this.value.getBytes());
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (start == 0L) {
            throw new SQLException("The first byte in the CLOB is at position 1");
        }
        --start;
        if (this.value == null) {
            return -1L;
        }
        Clob.checkLongValue(start, "start");
        int pos = this.value.indexOf(searchstr, (int)start);
        return pos >= 0 ? (long)(pos + 1) : (long)pos;
    }

    @Override
    public long position(java.sql.Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start--);
    }

    @Override
    public void free() throws SQLException {
        this.value = null;
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (pos < 1L || pos > (long)this.value.length() || pos + length > (long)this.value.length()) {
            throw new SQLException(MessageFormat.format("getCharacterStream({0},{1}) exceeds current length of this CLOB {2}", pos, length, this.value.length()));
        }
        return new StringReader(this.value.substring((int)pos - 1, (int)(pos + length - 1L)));
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (pos < 0L) {
            throw new SQLException(MessageFormat.format("setAsciiStream called with pos less than 0 ({0})", pos));
        }
        if (this.outputStream == null) {
            this.outputStream = new ClobOutputStream(pos);
        }
        this.outputStream.setPos(pos);
        return this.outputStream;
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (pos < 0L) {
            throw new SQLException(MessageFormat.format("setCharacterStream called with pos less than 0 ({0})", pos));
        }
        if (this.writer == null) {
            this.writer = new ClobWriter(pos);
        }
        this.writer.setPos(pos);
        return this.writer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int setString(long pos, String str) throws SQLException {
        Clob.checkLongValue(--pos, "position");
        if (this.value == null) {
            if (pos != 0L) throw new SQLException(MessageFormat.format("Position exceeds the current length of this CLOB {0}", 0));
            this.value = str;
            return str.length();
        } else {
            this.value = StringUtils.overwrite(this.value, (int)pos, str);
        }
        return str.length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        Clob.checkLongValue(--pos, "position");
        if (this.value == null) {
            if (pos != 0L) throw new SQLException(MessageFormat.format("Position exceeds the current length of this CLOB {0}", 0));
            this.value = str.substring(offset, offset + len);
            return len;
        } else {
            this.value = StringUtils.overwrite(this.value, (int)pos, str, offset, len);
        }
        return len;
    }

    @Override
    public void truncate(long length) throws SQLException {
        if (length > (long)StringUtils.size(this.value)) {
            throw new SQLException(MessageFormat.format("Unable to truncate length {0} exceeds length of the CLOB {1}", length, StringUtils.size(this.value)));
        }
        Clob.checkLongValue(length, "length");
        try {
            this.value = this.value.substring(0, (int)length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("clob index out of bounds", e);
        }
    }

    static void checkLongValue(long value, String argName) throws SQLException {
        if (value > Integer.MAX_VALUE) {
            throw new SQLException(MessageFormat.format("Position {0} is greater than max supported {1} of {2}", value, argName, Integer.MAX_VALUE));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Clob)) {
            return false;
        }
        Clob other = (Clob)obj;
        return StringUtils.equals(this.value, other.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    private class ClobWriter
    extends CharArrayWriter {
        private long output_pos = 0L;

        public ClobWriter(long pos) {
            this.output_pos = pos;
        }

        public void setPos(long pos) {
            this.output_pos = pos;
        }

        @Override
        public void write(String s, int off, int len) {
            try {
                Clob.this.setString(this.output_pos, s, off, len);
                this.output_pos += (long)len;
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle.getMessage());
            }
        }

        @Override
        public void write(int c) {
            char[] char_arr = new char[]{(char)c};
            String s = new String(char_arr);
            try {
                Clob.this.setString(this.output_pos, s, 0, 1);
                ++this.output_pos;
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle.getMessage());
            }
        }
    }

    private class ClobOutputStream
    extends ByteArrayOutputStream {
        private long output_pos = 0L;

        public ClobOutputStream(long pos) {
            this.output_pos = pos;
        }

        public void setPos(long pos) {
            this.output_pos = pos;
        }

        public void write(String s, int off, int len) {
            try {
                Clob.this.setString(this.output_pos, s, off, len);
                this.output_pos += (long)len;
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle.getMessage());
            }
        }

        @Override
        public void write(int c) {
            char[] char_arr = new char[]{(char)c};
            String s = new String(char_arr);
            try {
                Clob.this.setString(this.output_pos, s, 0, 1);
                ++this.output_pos;
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle.getMessage());
            }
        }
    }
}

