/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;

public class TestUtils {
    public static boolean flexEquals(Object one, Object two) {
        if (one instanceof byte[]) {
            return Arrays.equals((byte[])one, (byte[])two);
        }
        if (one instanceof short[]) {
            return Arrays.equals((short[])one, (short[])two);
        }
        if (one instanceof int[]) {
            return Arrays.equals((int[])one, (int[])two);
        }
        if (one instanceof long[]) {
            return Arrays.equals((long[])one, (long[])two);
        }
        if (one instanceof float[]) {
            return Arrays.equals((float[])one, (float[])two);
        }
        if (one instanceof double[]) {
            return Arrays.equals((double[])one, (double[])two);
        }
        if (one instanceof boolean[]) {
            return Arrays.equals((boolean[])one, (boolean[])two);
        }
        if (one.getClass().isArray()) {
            return Arrays.equals((Object[])one, (Object[])two);
        }
        if (one instanceof Number && two instanceof Number) {
            Number n1 = (Number)one;
            Number n2 = (Number)two;
            return n1.byteValue() == n2.byteValue() && n1.shortValue() == n2.shortValue() && n1.intValue() == n2.intValue() && n1.longValue() == n2.longValue() && n1.floatValue() == n2.floatValue() && n1.doubleValue() == n2.doubleValue();
        }
        return one == null ? two == null : one.equals(two);
    }

    public static String readFile(String fileName) {
        String string;
        File file = new File(fileName);
        FileReader reader = new FileReader(file);
        try {
            char[] chars = new char[(int)file.length()];
            for (long count = file.length(); count > 0L; count -= (long)reader.read(chars)) {
            }
            string = new String(chars);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed reading file", e);
            }
        }
        reader.close();
        return string;
    }

    public static String dumpThreads() {
        return TestUtils.dumpThreads(true);
    }

    public static String dumpThreads(boolean alwaysDumpThreads) {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] deadlocked = threadBean.findDeadlockedThreads();
        if (deadlocked == null || deadlocked.length == 0) {
            sb.append("\nNo deadlocks detected");
            if (!alwaysDumpThreads) {
                return sb.append("\n").toString();
            }
        } else {
            for (ThreadInfo info : threadBean.getThreadInfo(deadlocked)) {
                sb.append("\nDeadlocked Thread: ").append(info.getThreadName());
            }
        }
        sb.append("\nFull Thread Dump:");
        for (ThreadInfo info : threadBean.dumpAllThreads(true, true)) {
            sb.append("\n\"").append(info.getThreadName()).append("\"");
            sb.append(" ThreadId=").append(info.getThreadId());
            sb.append("\n    java.lang.Thread.State: ").append((Object)info.getThreadState());
            HashMap<StackTraceElement, MonitorInfo> monitorFrames = new HashMap<StackTraceElement, MonitorInfo>();
            for (MonitorInfo lock : info.getLockedMonitors()) {
                monitorFrames.put(lock.getLockedStackFrame(), lock);
            }
            LockInfo waitLock = info.getLockInfo();
            for (StackTraceElement element : info.getStackTrace()) {
                MonitorInfo lock;
                sb.append("\n        ").append(element);
                if (waitLock != null) {
                    sb.append("\n        ").append("- waiting on: ").append(TestUtils.formatLock(waitLock));
                    waitLock = null;
                }
                if ((lock = (MonitorInfo)monitorFrames.get(element)) == null) continue;
                sb.append("\n        ").append("- locked: ").append(TestUtils.formatLock(lock));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void dumpThreads(PrintStream out) {
        out.println(TestUtils.dumpThreads());
    }

    public static String formatLock(LockInfo lock) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(lock.getIdentityHashCode()).append(">");
        sb.append(" (a ").append(lock.getClassName()).append(")");
        return sb.toString();
    }
}

