/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import com.nuodb.impl.util.StringUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.ProtectionDomain;

public class Env {
    public static final String PROJECT_NAME = "nuodb";
    public static final String UNIX_EXECUTABLE_NAME = "nuodb";
    public static final String WINDOWS_EXECUTABLE_NAME = "nuodb.exe";
    public static final String NUODB_EXEC_PROP_NAME = "nuodbBinary";

    private static File windowsProfile() {
        String e = System.getenv("ALLUSERSPROFILE");
        return new File(e != null ? e : "C:\\ProgramData", "nuodb");
    }

    public static String homeDir(Class<?> clazz, String homeDir) {
        File homeFile;
        if (homeDir == null) {
            homeDir = System.getProperty("NUODB_HOME", System.getenv("NUODB_HOME"));
        }
        if (homeDir == null) {
            File t = Env.getContainingDirectory(clazz);
            homeDir = t.getParentFile().getAbsolutePath();
        }
        if (!(homeFile = new File(homeDir)).exists()) {
            throw new IllegalStateException("NuoDB home directory " + homeFile.getAbsolutePath() + " does not exist.");
        }
        return homeDir;
    }

    public static boolean isPackage(String homeDir) {
        File pkgFile = new File(new File(homeDir, "etc"), ".package.ver");
        return pkgFile.exists();
    }

    public static String configDir(String cfgDir, String homeDir) {
        if (cfgDir == null) {
            cfgDir = System.getProperty("NUODB_CFGDIR", System.getenv("NUODB_CFGDIR"));
        }
        if (cfgDir == null) {
            File cfgFile = !Env.isPackage(homeDir) ? new File(new File(homeDir, "var"), "etc") : (Env.isWindows() ? new File(Env.windowsProfile(), "etc") : new File(new File("/etc"), "nuodb"));
            cfgDir = cfgFile.getAbsolutePath();
        }
        return cfgDir;
    }

    public static String varDir(String varDir, String homeDir) {
        if (varDir == null) {
            varDir = System.getProperty("NUODB_VARDIR", System.getenv("NUODB_VARDIR"));
        }
        if (varDir == null) {
            File varDirFile = !Env.isPackage(homeDir) ? new File(new File(homeDir, "var"), "opt") : (Env.isWindows() ? new File(Env.windowsProfile(), "var") : new File(new File("/var/opt"), "nuodb"));
            varDir = varDirFile.getAbsolutePath();
        }
        return varDir;
    }

    public static String logDir(String logDir, String homeDir) {
        if (logDir == null) {
            logDir = System.getProperty("NUODB_LOGDIR", System.getenv("NUODB_LOGDIR"));
        }
        if (logDir == null) {
            File logFile = !Env.isPackage(homeDir) ? new File(new File(homeDir, "var"), "log") : (Env.isWindows() ? Env.windowsProfile() : new File(new File("/var/log"), "nuodb"));
            logDir = logFile.getAbsolutePath();
        }
        return logDir;
    }

    public static String crashDir(String crashDir, String homeDir) {
        if (crashDir == null) {
            crashDir = System.getProperty("NUODB_CRASHDIR", System.getenv("NUODB_CRASHDIR"));
        }
        if (crashDir == null) {
            String logDir = Env.logDir(System.getProperty("logDir"), homeDir);
            crashDir = new File(logDir, "crash").getAbsolutePath();
        }
        return crashDir;
    }

    public static String runDir(String runDir, String homeDir) {
        if (runDir == null) {
            runDir = System.getProperty("NUODB_RUNDIR", System.getenv("NUODB_RUNDIR"));
        }
        if (runDir == null) {
            File runDirFile = !Env.isPackage(homeDir) ? new File(new File(homeDir, "var"), "run") : (Env.isWindows() ? new File(Env.windowsProfile(), "run") : new File(new File("/var/run"), "nuodb"));
            runDir = runDirFile.getAbsolutePath();
        }
        return runDir;
    }

    public static String tmpDir(String tmpDir, File varDir) {
        if (tmpDir == null) {
            tmpDir = System.getProperty("NUODB_TEST_TEMP", System.getenv("NUODB_TEST_TEMP"));
        }
        if (tmpDir == null) {
            tmpDir = System.getProperty(Env.isWindows() ? "TEMP" : "TMPDIR");
        }
        if (tmpDir == null) {
            String profile;
            tmpDir = Env.isWindows() ? ((profile = System.getProperty("USERPROFILE", System.getenv("USERPROFILE"))) != null ? profile + File.separator + "AppData" + File.separator + "Local" + File.separator + "Temp" : varDir.getAbsolutePath()) : "/tmp";
        }
        return tmpDir;
    }

    public static String statusFile(String statusFile, String homeDir) {
        if (statusFile == null) {
            statusFile = System.getProperty("NUODB_ADMIN_STATUSFILE", System.getenv("NUODB_ADMIN_STATUSFILE"));
        }
        if (statusFile == null) {
            String runDir = Env.runDir(System.getProperty("runDir"), homeDir);
            File sFile = new File(runDir, "nuoadmin.status");
            statusFile = sFile.getAbsolutePath();
        }
        return statusFile;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static File getContainingDirectory(Class<?> clazz) {
        ProtectionDomain domain = clazz.getProtectionDomain();
        URL urlPath = domain.getCodeSource().getLocation();
        try {
            File pathFile = new File(urlPath.toURI());
            if (pathFile.isDirectory()) {
                return pathFile;
            }
            return pathFile.getParentFile();
        }
        catch (URISyntaxException ue) {
            throw new IllegalStateException("URI Syntax error ", ue);
        }
    }

    public static String getNuodbExecutableName() {
        String binary = System.getProperty(NUODB_EXEC_PROP_NAME, System.getenv(NUODB_EXEC_PROP_NAME));
        if (StringUtils.isBlank(binary)) {
            return Env.isWindows() ? WINDOWS_EXECUTABLE_NAME : "nuodb";
        }
        return binary;
    }
}

