/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean asDaemon;

    public NamedThreadFactory(String name) {
        this(name, false);
    }

    public NamedThreadFactory(String name, boolean asDaemon) {
        this.asDaemon = asDaemon;
        this.threadGroup = Thread.currentThread().getThreadGroup();
        this.namePrefix = name == null ? "pool-" : name + POOL_NUMBER.getAndIncrement() + "-";
    }

    @Override
    public Thread newThread(Runnable target) {
        Thread thread = new Thread(this.threadGroup, this.wrapTarget(target), this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (this.asDaemon && !thread.isDaemon()) {
            thread.setDaemon(true);
        }
        if (!this.asDaemon && thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }

    public Runnable wrapTarget(Runnable target) {
        return target;
    }
}

