/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.viewpageradapter;

import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.novoda.viewpageradapter.ViewIdGenerator;
import com.novoda.viewpageradapter.ViewPagerAdapterState;
import java.util.HashMap;
import java.util.Map;

public abstract class ViewPagerAdapter<V extends View>
extends PagerAdapter {
    private final Map<V, Integer> instantiatedViews = new HashMap<V, Integer>();
    private final ViewIdGenerator viewIdGenerator = new ViewIdGenerator();
    private ViewPagerAdapterState viewPagerAdapterState = ViewPagerAdapterState.newInstance();

    public V instantiateItem(ViewGroup container, int position) {
        V view = this.createView(container, position);
        SparseArray<Parcelable> viewState = this.viewPagerAdapterState.getViewState(position);
        int restoredId = this.viewPagerAdapterState.getId(position);
        view.setId(restoredId == -1 ? this.viewIdGenerator.generateViewId() : restoredId);
        this.bindView(view, position, viewState);
        this.instantiatedViews.put((Integer)view, position);
        container.addView(view);
        return view;
    }

    protected abstract V createView(ViewGroup var1, int var2);

    protected void bindView(V view, int position, @Nullable SparseArray<Parcelable> viewState) {
        this.bindView(view, position);
        if (viewState != null) {
            view.restoreHierarchyState(viewState);
        }
    }

    protected void bindView(V view, int position) {
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        for (Map.Entry<V, Integer> entry : this.instantiatedViews.entrySet()) {
            int position = entry.getValue();
            SparseArray<Parcelable> viewState = this.viewPagerAdapterState.getViewState(position);
            this.bindView((View)entry.getKey(), position, viewState);
        }
    }

    public void destroyItem(ViewGroup container, int position, Object key) {
        View view = (View)key;
        this.saveViewState(position, view);
        container.removeView(view);
        this.instantiatedViews.remove(view);
    }

    private void saveViewState(int position, V view) {
        SparseArray viewState = new SparseArray();
        view.saveHierarchyState(viewState);
        this.viewPagerAdapterState.put(view.getId(), position, (SparseArray<Parcelable>)viewState);
    }

    public Parcelable saveState() {
        for (Map.Entry<V, Integer> entry : this.instantiatedViews.entrySet()) {
            int position = entry.getValue();
            View view = (View)entry.getKey();
            this.saveViewState(position, view);
        }
        return this.viewPagerAdapterState;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (state instanceof ViewPagerAdapterState) {
            this.viewPagerAdapterState = (ViewPagerAdapterState)state;
        } else {
            super.restoreState(state, loader);
        }
    }

    public boolean isViewFromObject(View view, Object key) {
        return view.equals(key);
    }
}

