/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.viewpageradapter;

import android.os.Build;
import android.view.View;
import java.util.concurrent.atomic.AtomicInteger;

class ViewIdGenerator {
    ViewIdGenerator() {
    }

    int generateViewId() {
        if (Build.VERSION.SDK_INT >= 17) {
            return View.generateViewId();
        }
        return PreApi17ViewIdGenerator.generateViewId();
    }

    private static final class PreApi17ViewIdGenerator {
        private static final AtomicInteger NEXT_GENERATED_ID = new AtomicInteger(1);
        private static final int START_OF_AAPT_GENERATED_IDS = 0xFFFFFF;

        private PreApi17ViewIdGenerator() {
        }

        static int generateViewId() {
            int newValue;
            int result;
            do {
                if ((newValue = (result = NEXT_GENERATED_ID.get()) + 1) <= 0xFFFFFF) continue;
                newValue = 1;
            } while (!NEXT_GENERATED_ID.compareAndSet(result, newValue));
            return result;
        }
    }
}

