/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.viewpageradapter;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;

public class ViewPagerAdapterState
implements Parcelable {
    public static final Parcelable.Creator<ViewPagerAdapterState> CREATOR = new Parcelable.Creator<ViewPagerAdapterState>(){

        public ViewPagerAdapterState createFromParcel(Parcel in) {
            return ViewPagerAdapterState.from(in);
        }

        public ViewPagerAdapterState[] newArray(int size) {
            return new ViewPagerAdapterState[size];
        }
    };
    private final SparseArray<SparseArray<Parcelable>> viewStates;

    public static ViewPagerAdapterState newInstance() {
        return new ViewPagerAdapterState((SparseArray<SparseArray<Parcelable>>)new SparseArray());
    }

    private static ViewPagerAdapterState from(Parcel in) {
        Bundle bundle = in.readBundle(ViewPagerAdapterState.class.getClassLoader());
        SparseArray<SparseArray<Parcelable>> viewStates = ViewPagerAdapterState.extractViewStatesFrom(bundle);
        return new ViewPagerAdapterState(viewStates);
    }

    private static SparseArray<SparseArray<Parcelable>> extractViewStatesFrom(Bundle bundle) {
        SparseArray viewStates = new SparseArray(bundle.keySet().size());
        for (String key : bundle.keySet()) {
            SparseArray sparseParcelableArray = bundle.getSparseParcelableArray(key);
            viewStates.put(Integer.parseInt(key), (Object)sparseParcelableArray);
        }
        return viewStates;
    }

    private ViewPagerAdapterState(SparseArray<SparseArray<Parcelable>> viewStates) {
        this.viewStates = viewStates;
    }

    public void put(int position, SparseArray<Parcelable> viewState) {
        this.viewStates.put(position, viewState);
    }

    public SparseArray<Parcelable> get(int position) {
        return (SparseArray)this.viewStates.get(position);
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        for (int i = 0; i < this.viewStates.size(); ++i) {
            SparseArray viewState = (SparseArray)this.viewStates.get(i);
            bundle.putSparseParcelableArray(String.valueOf(i), viewState);
        }
        dest.writeBundle(bundle);
    }

    public int describeContents() {
        return 0;
    }
}

