/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.ToWaitFor;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

final class Wait {
    private Wait() {
    }

    static <T> ThenPerform<T> waitFor(Criteria criteria, Object lock) {
        return new ThenPerform(criteria, lock);
    }

    static class ThenPerform<T> {
        private final Criteria criteria;
        private final Object lock;

        ThenPerform(Criteria criteria, Object lock) {
            this.criteria = criteria;
            this.lock = lock;
        }

        T thenPerform(Action<T> action) {
            if (this.criteria.isNotSatisfied()) {
                this.waitForLock();
            }
            return action.performAction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"WA_NOT_IN_LOOP"}, justification="Using simple object lock.")
        private void waitForLock() {
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.criteria.isNotSatisfied()) {
                        this.lock.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Logger.e(e, "Interrupted waiting for instance.");
            }
        }

        static interface Action<T> {
            public T performAction();
        }
    }

    static class Criteria {
        @Nullable
        private ToWaitFor toWaitFor;

        Criteria() {
        }

        void update(ToWaitFor toWaitFor) {
            this.toWaitFor = toWaitFor;
        }

        boolean isNotSatisfied() {
            return this.toWaitFor == null;
        }
    }
}

