/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.StorageRequirementRule;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

final class StorageRequirementRules
implements StorageRequirementRule {
    private final List<StorageRequirementRule> rules;

    static StorageRequirementRules newInstance() {
        return new StorageRequirementRules(new ArrayList<StorageRequirementRule>());
    }

    private StorageRequirementRules(List<StorageRequirementRule> rules) {
        this.rules = rules;
    }

    void addRule(StorageRequirementRule storageRequirementRule) {
        this.rules.add(storageRequirementRule);
    }

    @Override
    public boolean hasViolatedRule(File storageDirectory, FileSize downloadFileSize) {
        for (StorageRequirementRule requirementRule : this.rules) {
            if (!requirementRule.hasViolatedRule(storageDirectory, downloadFileSize)) continue;
            return true;
        }
        return false;
    }
}

