/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.FloatRange;
import com.novoda.downloadmanager.ByteBasedRemainingStorageRequirementRule;
import com.novoda.downloadmanager.PercentageBasedRemainingStorageRequirementRule;
import com.novoda.downloadmanager.StorageCapacityReader;
import com.novoda.downloadmanager.StorageRequirementRule;

public final class StorageRequirementRuleFactory {
    private StorageRequirementRuleFactory() {
    }

    public static StorageRequirementRule createByteBasedRule(long bytesRemainingAfterDownload) {
        return new ByteBasedRemainingStorageRequirementRule(new StorageCapacityReader(), bytesRemainingAfterDownload);
    }

    public static StorageRequirementRule createPercentageBasedRule(@FloatRange(from=0.0, to=0.5) float percentageOfStorageRemaining) {
        return new PercentageBasedRemainingStorageRequirementRule(new StorageCapacityReader(), percentageOfStorageRemaining);
    }
}

