/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.novoda.downloadmanager.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class SqlDatabaseWrapper {
    private final SQLiteDatabase sqLiteDatabase;

    public SqlDatabaseWrapper(SQLiteDatabase sqLiteDatabase) {
        this.sqLiteDatabase = sqLiteDatabase;
    }

    public Cursor rawQuery(String query) {
        return this.sqLiteDatabase.rawQuery(query, null);
    }

    public Cursor rawQuery(String query, String selectionArgument, String ... selectionArguments) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(selectionArgument);
        arguments.addAll(Arrays.asList(selectionArguments));
        return this.sqLiteDatabase.rawQuery(query, arguments.toArray(new String[arguments.size()]));
    }

    public void close() {
        this.sqLiteDatabase.close();
    }

    public void deleteDatabase() {
        File outputFile = new File(this.sqLiteDatabase.getPath());
        if (outputFile.exists()) {
            boolean deleted = outputFile.delete();
            String message = String.format("File or Directory: %s deleted: %s", outputFile.getPath(), deleted);
            Logger.d(this.getClass().getSimpleName(), message);
        }
    }

    public void startTransaction() {
        this.sqLiteDatabase.beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.sqLiteDatabase.setTransactionSuccessful();
    }

    public void endTransaction() {
        this.sqLiteDatabase.endTransaction();
    }

    public void delete(String table, String whereClause, String selectionArgument, String ... selectionArguments) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(selectionArgument);
        arguments.addAll(Arrays.asList(selectionArguments));
        this.sqLiteDatabase.delete(table, whereClause, arguments.toArray(new String[arguments.size()]));
    }
}

