/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.app.Notification;
import android.support.annotation.WorkerThread;
import android.support.v4.app.NotificationManagerCompat;
import com.novoda.downloadmanager.DownloadManagerService;
import com.novoda.downloadmanager.NotificationCreator;
import com.novoda.downloadmanager.NotificationCustomizer;
import com.novoda.downloadmanager.NotificationInformation;
import com.novoda.downloadmanager.Wait;

class ServiceNotificationDispatcher<T> {
    private static final String NOTIFICATION_TAG = "download-manager";
    private final Object waitForDownloadService;
    private final Wait.Criteria serviceCriteria;
    private final NotificationCreator<T> notificationCreator;
    private final NotificationManagerCompat notificationManager;
    private int persistentNotificationId;
    private DownloadManagerService service;

    ServiceNotificationDispatcher(Object waitForDownloadService, Wait.Criteria serviceCriteria, NotificationCreator<T> notificationCreator, NotificationManagerCompat notificationManager) {
        this.waitForDownloadService = waitForDownloadService;
        this.serviceCriteria = serviceCriteria;
        this.notificationCreator = notificationCreator;
        this.notificationManager = notificationManager;
    }

    @WorkerThread
    void updateNotification(T payload) {
        Wait.waitFor(this.serviceCriteria, this.waitForDownloadService).thenPerform(this.executeUpdateNotification(payload));
    }

    private Wait.ThenPerform.Action<Void> executeUpdateNotification(T payload) {
        return () -> {
            NotificationInformation notificationInformation = this.notificationCreator.createNotification(payload);
            this.dismissStackedNotification(notificationInformation);
            switch (notificationInformation.notificationDisplayState()) {
                case SINGLE_PERSISTENT_NOTIFICATION: {
                    this.updatePersistentNotification(notificationInformation);
                    break;
                }
                case STACK_NOTIFICATION_NOT_DISMISSIBLE: {
                    this.stackNotificationNotDismissible(notificationInformation);
                    break;
                }
                case STACK_NOTIFICATION_DISMISSIBLE: {
                    this.stackNotification(notificationInformation);
                    break;
                }
                case HIDDEN_NOTIFICATION: {
                    this.dismissPersistentIfCurrent(notificationInformation);
                    break;
                }
                default: {
                    String message = String.format("%s: %s is not supported.", new Object[]{NotificationCustomizer.NotificationDisplayState.class.getSimpleName(), notificationInformation.notificationDisplayState()});
                    throw new IllegalArgumentException(message);
                }
            }
            return null;
        };
    }

    private void dismissStackedNotification(NotificationInformation notificationInformation) {
        this.notificationManager.cancel(NOTIFICATION_TAG, notificationInformation.getId());
    }

    private void updatePersistentNotification(NotificationInformation notificationInformation) {
        this.persistentNotificationId = notificationInformation.getId();
        this.service.start(notificationInformation.getId(), notificationInformation.getNotification());
    }

    private void stackNotification(NotificationInformation notificationInformation) {
        this.dismissPersistentIfCurrent(notificationInformation);
        Notification notification = notificationInformation.getNotification();
        this.notificationManager.notify(NOTIFICATION_TAG, notificationInformation.getId(), notification);
    }

    private void stackNotificationNotDismissible(NotificationInformation notificationInformation) {
        this.dismissPersistentIfCurrent(notificationInformation);
        Notification notification = notificationInformation.getNotification();
        notification.flags |= 2;
        this.notificationManager.notify(NOTIFICATION_TAG, notificationInformation.getId(), notification);
    }

    private void dismissPersistentIfCurrent(NotificationInformation notificationInformation) {
        if (this.persistentNotificationId == notificationInformation.getId()) {
            this.service.stop(true);
        }
    }

    void setService(DownloadManagerService service) {
        this.service = service;
        this.serviceCriteria.update(service);
    }
}

