/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.database.Cursor;
import com.novoda.downloadmanager.RoomFile;
import com.novoda.downloadmanager.RoomFileDao;
import java.util.ArrayList;
import java.util.List;

public class RoomFileDao_Impl
implements RoomFileDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfRoomFile;

    public RoomFileDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRoomFile = new EntityInsertionAdapter<RoomFile>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `RoomFile`(`file_id`,`batch_id`,`file_path`,`total_size`,`url`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, RoomFile value) {
                if (value.fileId == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.fileId);
                }
                if (value.batchId == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.batchId);
                }
                if (value.path == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.path);
                }
                stmt.bindLong(4, value.totalSize);
                if (value.url == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.url);
                }
            }
        };
    }

    @Override
    public void insert(RoomFile roomFile) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRoomFile.insert((Object)roomFile);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoomFile> loadAllFilesFor(String batchId) {
        String _sql = "SELECT * FROM RoomFile WHERE RoomFile.batch_id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM RoomFile WHERE RoomFile.batch_id = ?", (int)1);
        int _argIndex = 1;
        if (batchId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, batchId);
        }
        this.__db.beginTransaction();
        try {
            ArrayList<RoomFile> arrayList;
            Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
            try {
                int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("file_id");
                int _cursorIndexOfBatchId = _cursor.getColumnIndexOrThrow("batch_id");
                int _cursorIndexOfPath = _cursor.getColumnIndexOrThrow("file_path");
                int _cursorIndexOfTotalSize = _cursor.getColumnIndexOrThrow("total_size");
                int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("url");
                ArrayList<RoomFile> _result = new ArrayList<RoomFile>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    RoomFile _item = new RoomFile();
                    _item.fileId = _cursor.getString(_cursorIndexOfFileId);
                    _item.batchId = _cursor.getString(_cursorIndexOfBatchId);
                    _item.path = _cursor.getString(_cursorIndexOfPath);
                    _item.totalSize = _cursor.getLong(_cursorIndexOfTotalSize);
                    _item.url = _cursor.getString(_cursorIndexOfUrl);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoomFile> loadAllFiles() {
        String _sql = "SELECT * FROM RoomFile";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM RoomFile", (int)0);
        this.__db.beginTransaction();
        try {
            ArrayList<RoomFile> arrayList;
            Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
            try {
                int _cursorIndexOfFileId = _cursor.getColumnIndexOrThrow("file_id");
                int _cursorIndexOfBatchId = _cursor.getColumnIndexOrThrow("batch_id");
                int _cursorIndexOfPath = _cursor.getColumnIndexOrThrow("file_path");
                int _cursorIndexOfTotalSize = _cursor.getColumnIndexOrThrow("total_size");
                int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("url");
                ArrayList<RoomFile> _result = new ArrayList<RoomFile>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    RoomFile _item = new RoomFile();
                    _item.fileId = _cursor.getString(_cursorIndexOfFileId);
                    _item.batchId = _cursor.getString(_cursorIndexOfBatchId);
                    _item.path = _cursor.getString(_cursorIndexOfPath);
                    _item.totalSize = _cursor.getLong(_cursorIndexOfTotalSize);
                    _item.url = _cursor.getString(_cursorIndexOfUrl);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

