/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.content.Context;
import com.novoda.downloadmanager.CompletedDownloadBatch;
import com.novoda.downloadmanager.CompletedDownloadFile;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchIdCreator;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchTitle;
import com.novoda.downloadmanager.DownloadBatchTitleCreator;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileIdCreator;
import com.novoda.downloadmanager.DownloadsBatchPersisted;
import com.novoda.downloadmanager.DownloadsFilePersisted;
import com.novoda.downloadmanager.DownloadsPersistence;
import com.novoda.downloadmanager.LiteDownloadsBatchPersisted;
import com.novoda.downloadmanager.LiteDownloadsFilePersisted;
import com.novoda.downloadmanager.LiteFilePath;
import com.novoda.downloadmanager.RoomAppDatabase;
import com.novoda.downloadmanager.RoomBatch;
import com.novoda.downloadmanager.RoomFile;
import com.novoda.downloadmanager.StorageRoot;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

final class RoomDownloadsPersistence
implements DownloadsPersistence {
    private static final boolean NOTIFICATION_SEEN = true;
    private final RoomAppDatabase database;

    static RoomDownloadsPersistence newInstance(Context context) {
        RoomAppDatabase database = RoomAppDatabase.obtainInstance(context);
        return new RoomDownloadsPersistence(database);
    }

    private RoomDownloadsPersistence(RoomAppDatabase database) {
        this.database = database;
    }

    @Override
    public void startTransaction() {
        this.database.beginTransaction();
    }

    @Override
    public void endTransaction() {
        this.database.endTransaction();
    }

    @Override
    public void transactionSuccess() {
        this.database.setTransactionSuccessful();
    }

    @Override
    public void persistBatch(DownloadsBatchPersisted batchPersisted) {
        RoomBatch roomBatch = new RoomBatch();
        roomBatch.id = batchPersisted.downloadBatchId().rawId();
        roomBatch.status = batchPersisted.downloadBatchStatus().toRawValue();
        roomBatch.title = batchPersisted.downloadBatchTitle().asString();
        roomBatch.downloadedDateTimeInMillis = batchPersisted.downloadedDateTimeInMillis();
        roomBatch.notificationSeen = batchPersisted.notificationSeen();
        roomBatch.storageRoot = batchPersisted.storageRoot();
        this.database.roomBatchDao().insert(roomBatch);
    }

    @Override
    public List<DownloadsBatchPersisted> loadBatches() {
        List<RoomBatch> roomBatches = this.database.roomBatchDao().loadAll();
        ArrayList<DownloadsBatchPersisted> batchPersistedList = new ArrayList<DownloadsBatchPersisted>(roomBatches.size());
        for (RoomBatch roomBatch : roomBatches) {
            LiteDownloadsBatchPersisted batchPersisted = new LiteDownloadsBatchPersisted(DownloadBatchTitleCreator.createFrom(roomBatch.title), DownloadBatchIdCreator.createSanitizedFrom(roomBatch.id), DownloadBatchStatus.Status.from(roomBatch.status), roomBatch.downloadedDateTimeInMillis, roomBatch.notificationSeen, roomBatch.storageRoot);
            batchPersistedList.add(batchPersisted);
        }
        return batchPersistedList;
    }

    @Override
    public void persistFile(DownloadsFilePersisted filePersisted) {
        RoomFile roomFile = new RoomFile();
        roomFile.totalSize = filePersisted.totalFileSize();
        roomFile.batchId = filePersisted.downloadBatchId().rawId();
        roomFile.url = filePersisted.url();
        roomFile.path = filePersisted.filePath().path();
        roomFile.fileId = filePersisted.downloadFileId().rawId();
        this.database.roomFileDao().insert(roomFile);
    }

    @Override
    public List<DownloadsFilePersisted> loadAllFiles() {
        List<RoomFile> roomFiles = this.database.roomFileDao().loadAllFiles();
        return this.getDownloadsFilePersisted(roomFiles);
    }

    @Override
    public List<DownloadsFilePersisted> loadFiles(DownloadBatchId downloadBatchId) {
        List<RoomFile> roomFiles = this.database.roomFileDao().loadAllFilesFor(downloadBatchId.rawId());
        return this.getDownloadsFilePersisted(roomFiles);
    }

    private List<DownloadsFilePersisted> getDownloadsFilePersisted(List<RoomFile> roomFiles) {
        ArrayList<DownloadsFilePersisted> filePersistedList = new ArrayList<DownloadsFilePersisted>(roomFiles.size());
        for (RoomFile roomFile : roomFiles) {
            LiteDownloadsFilePersisted filePersisted = new LiteDownloadsFilePersisted(DownloadBatchIdCreator.createSanitizedFrom(roomFile.batchId), DownloadFileIdCreator.createFrom(roomFile.fileId), new LiteFilePath(roomFile.path), roomFile.totalSize, roomFile.url);
            filePersistedList.add(filePersisted);
        }
        return filePersistedList;
    }

    @Override
    public boolean delete(DownloadBatchId downloadBatchId) {
        RoomBatch roomBatch = this.database.roomBatchDao().load(downloadBatchId.rawId());
        if (roomBatch == null) {
            return false;
        }
        this.database.roomBatchDao().delete(roomBatch);
        return true;
    }

    @Override
    public boolean update(DownloadBatchId downloadBatchId, DownloadBatchStatus.Status status) {
        RoomBatch roomBatch = this.database.roomBatchDao().load(downloadBatchId.rawId());
        if (roomBatch == null) {
            return false;
        }
        roomBatch.status = status.toRawValue();
        this.database.roomBatchDao().update(roomBatch);
        return true;
    }

    @Override
    public boolean update(DownloadBatchId downloadBatchId, boolean notificationSeen) {
        RoomBatch roomBatch = this.database.roomBatchDao().load(downloadBatchId.rawId());
        if (roomBatch == null) {
            return false;
        }
        roomBatch.notificationSeen = notificationSeen;
        this.database.roomBatchDao().update(roomBatch);
        return true;
    }

    @Override
    public void persistCompletedBatch(CompletedDownloadBatch completedDownloadBatch) {
        DownloadBatchId downloadBatchId = completedDownloadBatch.downloadBatchId();
        DownloadBatchTitle downloadBatchTitle = completedDownloadBatch.downloadBatchTitle();
        DownloadBatchStatus.Status downloadBatchStatus = DownloadBatchStatus.Status.DOWNLOADED;
        long downloadedDateTimeInMillis = completedDownloadBatch.downloadedDateTimeInMillis();
        StorageRoot storageRoot = completedDownloadBatch.storageRoot();
        LiteDownloadsBatchPersisted persistedBatch = new LiteDownloadsBatchPersisted(downloadBatchTitle, downloadBatchId, downloadBatchStatus, downloadedDateTimeInMillis, true, storageRoot.path());
        this.persistBatch(persistedBatch);
        for (CompletedDownloadFile completedDownloadFile : completedDownloadBatch.completedDownloadFiles()) {
            String url = completedDownloadFile.originalNetworkAddress();
            String rawDownloadFileId = this.rawFileIdFrom(completedDownloadBatch.downloadBatchTitle(), completedDownloadFile);
            DownloadFileId downloadFileId = DownloadFileIdCreator.createFrom(rawDownloadFileId);
            LiteDownloadsFilePersisted persistedFile = new LiteDownloadsFilePersisted(downloadBatchId, downloadFileId, new LiteFilePath(completedDownloadFile.newFileLocation()), completedDownloadFile.fileSize().totalSize(), url);
            this.persistFile(persistedFile);
        }
    }

    private String rawFileIdFrom(DownloadBatchTitle batch, CompletedDownloadFile completedDownloadFile) {
        if (completedDownloadFile.fileId() == null || completedDownloadFile.fileId().isEmpty()) {
            return batch.asString() + UUID.randomUUID();
        }
        return completedDownloadFile.fileId();
    }
}

