/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.database.Cursor;
import com.novoda.downloadmanager.RoomBatch;
import com.novoda.downloadmanager.RoomBatchDao;
import java.util.ArrayList;
import java.util.List;

public class RoomBatchDao_Impl
implements RoomBatchDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfRoomBatch;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfRoomBatch;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfRoomBatch;

    public RoomBatchDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRoomBatch = new EntityInsertionAdapter<RoomBatch>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `RoomBatch`(`batch_id`,`batch_title`,`batch_status`,`batch_downloaded_date_time_in_millis`,`notification_seen`,`storage_root`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, RoomBatch value) {
                if (value.id == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.id);
                }
                if (value.title == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.title);
                }
                if (value.status == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.status);
                }
                stmt.bindLong(4, value.downloadedDateTimeInMillis);
                int _tmp = value.notificationSeen ? 1 : 0;
                stmt.bindLong(5, (long)_tmp);
                if (value.storageRoot == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.storageRoot);
                }
            }
        };
        this.__deletionAdapterOfRoomBatch = new EntityDeletionOrUpdateAdapter<RoomBatch>(__db){

            public String createQuery() {
                return "DELETE FROM `RoomBatch` WHERE `batch_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RoomBatch value) {
                if (value.id == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.id);
                }
            }
        };
        this.__updateAdapterOfRoomBatch = new EntityDeletionOrUpdateAdapter<RoomBatch>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `RoomBatch` SET `batch_id` = ?,`batch_title` = ?,`batch_status` = ?,`batch_downloaded_date_time_in_millis` = ?,`notification_seen` = ?,`storage_root` = ? WHERE `batch_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RoomBatch value) {
                if (value.id == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.id);
                }
                if (value.title == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.title);
                }
                if (value.status == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.status);
                }
                stmt.bindLong(4, value.downloadedDateTimeInMillis);
                int _tmp = value.notificationSeen ? 1 : 0;
                stmt.bindLong(5, (long)_tmp);
                if (value.storageRoot == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.storageRoot);
                }
                if (value.id == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.id);
                }
            }
        };
    }

    @Override
    public void insert(RoomBatch roomBatch) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRoomBatch.insert((Object)roomBatch);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(RoomBatch ... roomBatches) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRoomBatch.handleMultiple((Object[])roomBatches);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(RoomBatch ... roomBatches) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfRoomBatch.handleMultiple((Object[])roomBatches);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RoomBatch> loadAll() {
        String _sql = "SELECT * FROM RoomBatch";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM RoomBatch", (int)0);
        this.__db.beginTransaction();
        try {
            ArrayList<RoomBatch> arrayList;
            Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
            try {
                int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("batch_id");
                int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("batch_title");
                int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("batch_status");
                int _cursorIndexOfDownloadedDateTimeInMillis = _cursor.getColumnIndexOrThrow("batch_downloaded_date_time_in_millis");
                int _cursorIndexOfNotificationSeen = _cursor.getColumnIndexOrThrow("notification_seen");
                int _cursorIndexOfStorageRoot = _cursor.getColumnIndexOrThrow("storage_root");
                ArrayList<RoomBatch> _result = new ArrayList<RoomBatch>(_cursor.getCount());
                while (_cursor.moveToNext()) {
                    RoomBatch _item = new RoomBatch();
                    _item.id = _cursor.getString(_cursorIndexOfId);
                    _item.title = _cursor.getString(_cursorIndexOfTitle);
                    _item.status = _cursor.getString(_cursorIndexOfStatus);
                    _item.downloadedDateTimeInMillis = _cursor.getLong(_cursorIndexOfDownloadedDateTimeInMillis);
                    int _tmp = _cursor.getInt(_cursorIndexOfNotificationSeen);
                    _item.notificationSeen = _tmp != 0;
                    _item.storageRoot = _cursor.getString(_cursorIndexOfStorageRoot);
                    _result.add(_item);
                }
                this.__db.setTransactionSuccessful();
                arrayList = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return arrayList;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoomBatch load(String batchId) {
        String _sql = "SELECT * FROM RoomBatch WHERE RoomBatch.batch_id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM RoomBatch WHERE RoomBatch.batch_id = ?", (int)1);
        int _argIndex = 1;
        if (batchId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, batchId);
        }
        this.__db.beginTransaction();
        try {
            RoomBatch roomBatch;
            Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
            try {
                RoomBatch _result;
                int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("batch_id");
                int _cursorIndexOfTitle = _cursor.getColumnIndexOrThrow("batch_title");
                int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("batch_status");
                int _cursorIndexOfDownloadedDateTimeInMillis = _cursor.getColumnIndexOrThrow("batch_downloaded_date_time_in_millis");
                int _cursorIndexOfNotificationSeen = _cursor.getColumnIndexOrThrow("notification_seen");
                int _cursorIndexOfStorageRoot = _cursor.getColumnIndexOrThrow("storage_root");
                if (_cursor.moveToFirst()) {
                    _result = new RoomBatch();
                    _result.id = _cursor.getString(_cursorIndexOfId);
                    _result.title = _cursor.getString(_cursorIndexOfTitle);
                    _result.status = _cursor.getString(_cursorIndexOfStatus);
                    _result.downloadedDateTimeInMillis = _cursor.getLong(_cursorIndexOfDownloadedDateTimeInMillis);
                    int _tmp = _cursor.getInt(_cursorIndexOfNotificationSeen);
                    _result.notificationSeen = _tmp != 0;
                    _result.storageRoot = _cursor.getString(_cursorIndexOfStorageRoot);
                } else {
                    _result = null;
                }
                this.__db.setTransactionSuccessful();
                roomBatch = _result;
            }
            catch (Throwable throwable) {
                _cursor.close();
                _statement.release();
                throw throwable;
            }
            _cursor.close();
            _statement.release();
            return roomBatch;
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

