/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.util.TableInfo;
import android.content.Context;
import android.os.Build;
import com.novoda.downloadmanager.RoomAppDatabase;
import com.novoda.downloadmanager.RoomBatchDao;
import com.novoda.downloadmanager.RoomBatchDao_Impl;
import com.novoda.downloadmanager.RoomFileDao;
import com.novoda.downloadmanager.RoomFileDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class RoomAppDatabase_Impl
extends RoomAppDatabase {
    private volatile RoomBatchDao _roomBatchDao;
    private volatile RoomFileDao _roomFileDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(4){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `RoomBatch` (`batch_id` TEXT NOT NULL, `batch_title` TEXT, `batch_status` TEXT, `batch_downloaded_date_time_in_millis` INTEGER NOT NULL, `notification_seen` INTEGER NOT NULL, `storage_root` TEXT, PRIMARY KEY(`batch_id`))");
                _db.execSQL("CREATE  INDEX `index_RoomBatch_batch_id` ON `RoomBatch` (`batch_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `RoomFile` (`file_id` TEXT NOT NULL, `batch_id` TEXT NOT NULL, `file_path` TEXT, `total_size` INTEGER NOT NULL, `url` TEXT, PRIMARY KEY(`file_id`, `batch_id`), FOREIGN KEY(`batch_id`) REFERENCES `RoomBatch`(`batch_id`) ON UPDATE NO ACTION ON DELETE CASCADE )");
                _db.execSQL("CREATE  INDEX `index_RoomFile_batch_id` ON `RoomFile` (`batch_id`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, \"95ffbd76d610ab0a35aab06a7f4dc4bc\")");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `RoomBatch`");
                _db.execSQL("DROP TABLE IF EXISTS `RoomFile`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (RoomAppDatabase_Impl.this.mCallbacks != null) {
                    int _size = RoomAppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)RoomAppDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                RoomAppDatabase_Impl.this.mDatabase = _db;
                _db.execSQL("PRAGMA foreign_keys = ON");
                RoomAppDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (RoomAppDatabase_Impl.this.mCallbacks != null) {
                    int _size = RoomAppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)RoomAppDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsRoomBatch = new HashMap<String, TableInfo.Column>(6);
                _columnsRoomBatch.put("batch_id", new TableInfo.Column("batch_id", "TEXT", true, 1));
                _columnsRoomBatch.put("batch_title", new TableInfo.Column("batch_title", "TEXT", false, 0));
                _columnsRoomBatch.put("batch_status", new TableInfo.Column("batch_status", "TEXT", false, 0));
                _columnsRoomBatch.put("batch_downloaded_date_time_in_millis", new TableInfo.Column("batch_downloaded_date_time_in_millis", "INTEGER", true, 0));
                _columnsRoomBatch.put("notification_seen", new TableInfo.Column("notification_seen", "INTEGER", true, 0));
                _columnsRoomBatch.put("storage_root", new TableInfo.Column("storage_root", "TEXT", false, 0));
                HashSet _foreignKeysRoomBatch = new HashSet(0);
                HashSet<TableInfo.Index> _indicesRoomBatch = new HashSet<TableInfo.Index>(1);
                _indicesRoomBatch.add(new TableInfo.Index("index_RoomBatch_batch_id", false, Arrays.asList("batch_id")));
                TableInfo _infoRoomBatch = new TableInfo("RoomBatch", _columnsRoomBatch, _foreignKeysRoomBatch, _indicesRoomBatch);
                TableInfo _existingRoomBatch = TableInfo.read((SupportSQLiteDatabase)_db, (String)"RoomBatch");
                if (!_infoRoomBatch.equals((Object)_existingRoomBatch)) {
                    throw new IllegalStateException("Migration didn't properly handle RoomBatch(com.novoda.downloadmanager.RoomBatch).\n Expected:\n" + _infoRoomBatch + "\n" + " Found:\n" + _existingRoomBatch);
                }
                HashMap<String, TableInfo.Column> _columnsRoomFile = new HashMap<String, TableInfo.Column>(5);
                _columnsRoomFile.put("file_id", new TableInfo.Column("file_id", "TEXT", true, 1));
                _columnsRoomFile.put("batch_id", new TableInfo.Column("batch_id", "TEXT", true, 2));
                _columnsRoomFile.put("file_path", new TableInfo.Column("file_path", "TEXT", false, 0));
                _columnsRoomFile.put("total_size", new TableInfo.Column("total_size", "INTEGER", true, 0));
                _columnsRoomFile.put("url", new TableInfo.Column("url", "TEXT", false, 0));
                HashSet<TableInfo.ForeignKey> _foreignKeysRoomFile = new HashSet<TableInfo.ForeignKey>(1);
                _foreignKeysRoomFile.add(new TableInfo.ForeignKey("RoomBatch", "CASCADE", "NO ACTION", Arrays.asList("batch_id"), Arrays.asList("batch_id")));
                HashSet<TableInfo.Index> _indicesRoomFile = new HashSet<TableInfo.Index>(1);
                _indicesRoomFile.add(new TableInfo.Index("index_RoomFile_batch_id", false, Arrays.asList("batch_id")));
                TableInfo _infoRoomFile = new TableInfo("RoomFile", _columnsRoomFile, _foreignKeysRoomFile, _indicesRoomFile);
                TableInfo _existingRoomFile = TableInfo.read((SupportSQLiteDatabase)_db, (String)"RoomFile");
                if (!_infoRoomFile.equals((Object)_existingRoomFile)) {
                    throw new IllegalStateException("Migration didn't properly handle RoomFile(com.novoda.downloadmanager.RoomFile).\n Expected:\n" + _infoRoomFile + "\n" + " Found:\n" + _existingRoomFile);
                }
            }
        }, "95ffbd76d610ab0a35aab06a7f4dc4bc", "72a0f2ab42361319002b1abcc4952be1");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        return new InvalidationTracker((RoomDatabase)this, new String[]{"RoomBatch", "RoomFile"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        boolean _supportsDeferForeignKeys = Build.VERSION.SDK_INT >= 21;
        try {
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = FALSE");
            }
            super.beginTransaction();
            if (_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
            }
            _db.execSQL("DELETE FROM `RoomBatch`");
            _db.execSQL("DELETE FROM `RoomFile`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            if (!_supportsDeferForeignKeys) {
                _db.execSQL("PRAGMA foreign_keys = TRUE");
            }
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RoomBatchDao roomBatchDao() {
        if (this._roomBatchDao != null) {
            return this._roomBatchDao;
        }
        RoomAppDatabase_Impl roomAppDatabase_Impl = this;
        synchronized (roomAppDatabase_Impl) {
            if (this._roomBatchDao == null) {
                this._roomBatchDao = new RoomBatchDao_Impl(this);
            }
            return this._roomBatchDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RoomFileDao roomFileDao() {
        if (this._roomFileDao != null) {
            return this._roomFileDao;
        }
        RoomAppDatabase_Impl roomAppDatabase_Impl = this;
        synchronized (roomAppDatabase_Impl) {
            if (this._roomFileDao == null) {
                this._roomFileDao = new RoomFileDao_Impl(this);
            }
            return this._roomFileDao;
        }
    }
}

