/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;
import android.support.annotation.NonNull;
import com.novoda.downloadmanager.RoomBatch;
import com.novoda.downloadmanager.RoomBatchDao;
import com.novoda.downloadmanager.RoomFile;
import com.novoda.downloadmanager.RoomFileDao;
import com.novoda.downloadmanager.StorageRoot;
import com.novoda.downloadmanager.StorageRootFactory;

@Database(entities={RoomBatch.class, RoomFile.class}, version=4)
abstract class RoomAppDatabase
extends RoomDatabase {
    private static final int VERSION_ONE = 1;
    private static final int VERSION_TWO = 2;
    private static final int VERSION_THREE = 3;
    private static final int VERSION_FOUR = 4;
    private static volatile RoomAppDatabase singleInstance;

    RoomAppDatabase() {
    }

    abstract RoomBatchDao roomBatchDao();

    abstract RoomFileDao roomFileDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static RoomAppDatabase obtainInstance(Context context) {
        if (singleInstance != null) return singleInstance;
        Class<RoomAppDatabase> clazz = RoomAppDatabase.class;
        synchronized (RoomAppDatabase.class) {
            if (singleInstance != null) return singleInstance;
            singleInstance = RoomAppDatabase.newInstance(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleInstance;
        }
    }

    static RoomAppDatabase newInstance(Context context) {
        StorageRoot storageRoot = StorageRootFactory.createPrimaryStorageDownloadsDirectoryRoot(context.getApplicationContext());
        return (RoomAppDatabase)Room.databaseBuilder((Context)context.getApplicationContext(), RoomAppDatabase.class, (String)"database-litedownloadmanager").addMigrations(new Migration[]{new VersionOneToVersionTwoMigration()}).addMigrations(new Migration[]{new VersionTwoToVersionThreeMigration(storageRoot)}).addMigrations(new Migration[]{new VersionThreeToVersionFourMigration()}).build();
    }

    private static final class VersionThreeToVersionFourMigration
    extends Migration {
        VersionThreeToVersionFourMigration() {
            super(3, 4);
        }

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `RoomFileTemp` (`file_id` TEXT NOT NULL, `batch_id` TEXT NOT NULL, `file_path` TEXT, `total_size` INTEGER NOT NULL, `url` TEXT, PRIMARY KEY(`file_id`, `batch_id`), FOREIGN KEY(`batch_id`) REFERENCES `RoomBatch`(`batch_id`) ON UPDATE NO ACTION ON DELETE CASCADE )");
            database.execSQL("DROP INDEX IF EXISTS `index_RoomFileTemp_batch_id`");
            database.execSQL("CREATE INDEX IF NOT EXISTS `index_RoomFileTemp_batch_id` ON `RoomFileTemp` (`batch_id`)");
            database.execSQL("INSERT INTO RoomFileTemp (file_id, batch_id, file_path, total_size, url) SELECT file_id, batch_id, file_path, total_size, url FROM RoomFile");
            database.execSQL("DROP TABLE IF EXISTS RoomFile");
            database.execSQL("ALTER TABLE RoomFileTemp RENAME TO RoomFile");
        }
    }

    private static final class VersionTwoToVersionThreeMigration
    extends Migration {
        private final StorageRoot storageRoot;

        VersionTwoToVersionThreeMigration(StorageRoot storageRoot) {
            super(2, 3);
            this.storageRoot = storageRoot;
        }

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE RoomBatch ADD COLUMN 'storage_root' TEXT DEFAULT '" + this.storageRoot.path() + "'");
        }
    }

    private static final class VersionOneToVersionTwoMigration
    extends Migration {
        VersionOneToVersionTwoMigration() {
            super(1, 2);
        }

        public void migrate(@NonNull SupportSQLiteDatabase database) {
            database.execSQL("CREATE TABLE IF NOT EXISTS `RoomFileTemp` (`file_id` TEXT NOT NULL, `batch_id` TEXT NOT NULL, `file_path` TEXT, `total_size` INTEGER NOT NULL, `url` TEXT, `persistence_type` TEXT, PRIMARY KEY(`file_id`, `batch_id`), FOREIGN KEY(`batch_id`) REFERENCES `RoomBatch`(`batch_id`) ON UPDATE NO ACTION ON DELETE CASCADE )");
            database.execSQL("DROP INDEX IF EXISTS `index_RoomFileTemp_batch_id`");
            database.execSQL("CREATE INDEX IF NOT EXISTS `index_RoomFileTemp_batch_id` ON `RoomFileTemp` (`batch_id`)");
            database.execSQL("INSERT INTO RoomFileTemp (file_id, batch_id, file_path, total_size, url, persistence_type) SELECT file_id, batch_id, file_path, total_size, url, persistence_type FROM RoomFile");
            database.execSQL("DROP TABLE IF EXISTS RoomFile");
            database.execSQL("ALTER TABLE RoomFileTemp RENAME TO RoomFile");
        }
    }
}

