/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.FloatRange;
import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.StorageCapacityReader;
import com.novoda.downloadmanager.StorageRequirementRule;
import java.io.File;

class PercentageBasedRemainingStorageRequirementRule
implements StorageRequirementRule {
    private final StorageCapacityReader storageCapacityReader;
    private final float percentageOfStorageRemaining;

    PercentageBasedRemainingStorageRequirementRule(StorageCapacityReader storageCapacityReader, @FloatRange(from=0.0, to=0.5) float percentageOfStorageRemaining) {
        this.storageCapacityReader = storageCapacityReader;
        this.percentageOfStorageRemaining = percentageOfStorageRemaining;
    }

    @Override
    public boolean hasViolatedRule(File storageDirectory, FileSize downloadFileSize) {
        long storageCapacityInBytes = this.storageCapacityReader.storageCapacityInBytes(storageDirectory.getPath());
        long minimumStorageRequiredInBytes = (long)((float)storageCapacityInBytes * this.percentageOfStorageRemaining);
        long usableStorageInBytes = storageDirectory.getUsableSpace();
        long remainingStorageAfterDownloadInBytes = usableStorageInBytes - downloadFileSize.remainingSize();
        Logger.v("Storage capacity in bytes: ", storageCapacityInBytes);
        Logger.v("Usable storage in bytes: ", usableStorageInBytes);
        Logger.v("Minimum required storage in bytes: ", minimumStorageRequiredInBytes);
        return remainingStorageAfterDownloadInBytes < minimumStorageRequiredInBytes;
    }
}

