/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

final class Optional<T> {
    private static final Optional ABSENT = new Optional<Object>(null);
    private final T data;

    static <T> Optional<T> absent() {
        return ABSENT;
    }

    static <T> Optional<T> fromNullable(T data) {
        if (data == null) {
            return Optional.absent();
        }
        return new Optional<T>(data);
    }

    static <T> Optional<T> of(T data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null. Use Optional.fromNullable(maybeNullData).");
        }
        return new Optional<T>(data);
    }

    private Optional(T data) {
        this.data = data;
    }

    boolean isPresent() {
        return this.data != null;
    }

    boolean isAbsent() {
        return !this.isPresent();
    }

    T get() {
        if (!this.isPresent()) {
            throw new IllegalStateException("You must check if data is present before using get()");
        }
        return this.data;
    }

    T or(T elseCase) {
        return this.isPresent() ? this.get() : elseCase;
    }

    Optional<T> or(Optional<T> elseCase) {
        return this.isPresent() ? this : elseCase;
    }

    Optional<T> or(Func0<Optional<T>> elseFunc) {
        return this.isPresent() ? this : elseFunc.call();
    }

    Optional<T> filter(Predicate<T> condition) {
        return this.isPresent() && condition.isValid(this.get()) ? this : Optional.absent();
    }

    Optional<T> filterNot(Predicate<T> condition) {
        return this.filter(it -> !condition.isValid(it));
    }

    <P> Optional<P> map(Func1<T, P> transformation) {
        return this.isPresent() ? Optional.of(transformation.call(this.get())) : Optional.absent();
    }

    T getOrElse(Func0<T> elseFunc) {
        return this.isPresent() ? this.get() : elseFunc.call();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Optional optional = (Optional)o;
        return this.data != null ? this.data.equals(optional.data) : optional.data == null;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public String toString() {
        return String.format("Optional<%s>", this.isAbsent() ? "Absent" : this.data.toString());
    }

    static interface Predicate<V> {
        public boolean isValid(V var1);
    }

    static interface Func1<V, R> {
        public R call(V var1);
    }

    static interface Func0<V> {
        public V call();
    }
}

