/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.LiteNetworkRequest;
import com.novoda.downloadmanager.NetworkRequest;
import java.util.HashMap;
import java.util.Map;

class NetworkRequestCreator {
    private static final String DOWNLOADED_BYTES_VALUE_FORMAT = "bytes=%s-%s";
    private static final Map<String, String> DISABLE_COMPRESSION_HEADERS = new HashMap<String, String>(1);

    NetworkRequestCreator() {
    }

    NetworkRequest createFileSizeHeadRequest(String url) {
        return new LiteNetworkRequest(DISABLE_COMPRESSION_HEADERS, url, NetworkRequest.Method.HEAD);
    }

    NetworkRequest createFileSizeBodyRequest(String url) {
        return new LiteNetworkRequest(DISABLE_COMPRESSION_HEADERS, url, NetworkRequest.Method.GET);
    }

    NetworkRequest createDownloadRequest(String url) {
        return new LiteNetworkRequest(new HashMap<String, String>(), url, NetworkRequest.Method.GET);
    }

    NetworkRequest createDownloadRequestWithDownloadedBytesHeader(String url, long currentSize, long totalSize) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String headerValue = String.format(DOWNLOADED_BYTES_VALUE_FORMAT, currentSize, totalSize - 1L);
        headers.put("Range", headerValue);
        return new LiteNetworkRequest(headers, url, NetworkRequest.Method.GET);
    }

    static {
        DISABLE_COMPRESSION_HEADERS.put("Accept-Encoding", "identity");
    }
}

