/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.FileSizeCreator;
import com.novoda.downloadmanager.FileSizeRequester;
import com.novoda.downloadmanager.HttpClient;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.NetworkRequest;
import com.novoda.downloadmanager.NetworkRequestCreator;
import com.novoda.downloadmanager.NetworkResponse;
import java.io.IOException;

class NetworkFileSizeRequester
implements FileSizeRequester {
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final int UNKNOWN_CONTENT_LENGTH = -1;
    private static final int ZERO_FILE_SIZE = 0;
    private final HttpClient httpClient;
    private final NetworkRequestCreator requestCreator;

    NetworkFileSizeRequester(HttpClient httpClient, NetworkRequestCreator requestCreator) {
        this.httpClient = httpClient;
        this.requestCreator = requestCreator;
    }

    @Override
    public FileSize requestFileSize(String url) {
        try {
            long fileSize = this.executeRequestFileSize(url);
            if (fileSize == -1L || fileSize == 0L) {
                return FileSizeCreator.unknownFileSize();
            }
            return FileSizeCreator.createFromTotalSize(fileSize);
        }
        catch (IOException e) {
            Logger.e(e, "Error requesting file size for " + url);
            return FileSizeCreator.unknownFileSize();
        }
    }

    private long executeRequestFileSize(String url) throws IOException {
        long fileSize = this.requestFileSizeThroughHeaderRequest(url);
        if (fileSize == -1L || fileSize == 0L) {
            Logger.w(String.format("file size header request '%s' returned %s, we'll try with a body request", url, fileSize));
            fileSize = this.requestFileSizeThroughBodyRequest(url);
            if (fileSize == -1L || fileSize == 0L) {
                Logger.w(String.format("file size body request '%s' returned %s", url, fileSize));
            }
        }
        return fileSize;
    }

    private long requestFileSizeThroughHeaderRequest(String url) throws IOException {
        NetworkRequest fileSizeRequest = this.requestCreator.createFileSizeHeadRequest(url);
        NetworkResponse response = this.httpClient.execute(fileSizeRequest);
        long fileSize = 0L;
        if (response.isSuccessful()) {
            fileSize = Long.parseLong(response.header(HEADER_CONTENT_LENGTH, String.valueOf(-1)));
            response.closeByteStream();
        }
        return fileSize;
    }

    private long requestFileSizeThroughBodyRequest(String url) throws IOException {
        NetworkRequest downloadRequest = this.requestCreator.createFileSizeBodyRequest(url);
        NetworkResponse response = this.httpClient.execute(downloadRequest);
        long fileSize = 0L;
        if (response.isSuccessful()) {
            fileSize = response.bodyContentLength();
            response.closeByteStream();
        }
        return fileSize;
    }
}

