/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.FileDownloader;
import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.HttpClient;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.NetworkRequest;
import com.novoda.downloadmanager.NetworkRequestCreator;
import com.novoda.downloadmanager.NetworkResponse;
import java.io.IOException;
import java.io.InputStream;

class NetworkFileDownloader
implements FileDownloader {
    private static final int BUFFER_SIZE = 4096;
    private final HttpClient httpClient;
    private final NetworkRequestCreator requestCreator;
    private boolean canDownload;

    NetworkFileDownloader(HttpClient httpClient, NetworkRequestCreator requestCreator) {
        this.httpClient = httpClient;
        this.requestCreator = requestCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void startDownloading(String url, FileSize fileSize, FileDownloader.Callback callback) {
        block13: {
            this.canDownload = true;
            NetworkRequest request = this.createRequestFrom(url, fileSize);
            NetworkResponse response = null;
            response = this.httpClient.execute(request);
            int responseCode = response.code();
            this.processResponse(callback, response, responseCode, url);
            try {
                if (response != null) {
                    response.closeByteStream();
                }
                break block13;
            }
            catch (IOException e) {
                Logger.e(e, "Exception while closing the body response");
            }
            break block13;
            catch (IOException e) {
                try {
                    Logger.e(e, "Exception with http request");
                    callback.onError(e.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            response.closeByteStream();
                        }
                    }
                    catch (IOException e2) {
                        Logger.e(e2, "Exception while closing the body response");
                    }
                    throw throwable;
                }
                try {
                    if (response != null) {
                        response.closeByteStream();
                    }
                }
                catch (IOException e3) {
                    Logger.e(e3, "Exception while closing the body response");
                }
            }
        }
        callback.onDownloadFinished();
    }

    private void processResponse(FileDownloader.Callback callback, NetworkResponse response, int responseCode, String url) throws IOException {
        if (this.isValid(responseCode)) {
            byte[] buffer = new byte[4096];
            int readLast = 0;
            try (InputStream in = response.openByteStream();){
                while (this.canDownload && readLast != -1) {
                    readLast = in.read(buffer);
                    if (readLast == 0 || readLast == -1) continue;
                    callback.onBytesRead(buffer, readLast);
                }
            }
        } else {
            Logger.e("Network response code is not ok, responseCode: " + responseCode);
            String networkErrorMessage = String.format("Request: %s with response code: %s failed.", url, responseCode);
            callback.onError(networkErrorMessage);
        }
    }

    private boolean isValid(int responseCode) {
        return responseCode == 200 || responseCode == 206;
    }

    private NetworkRequest createRequestFrom(String url, FileSize fileSize) {
        if (fileSize.areBytesDownloadedKnown()) {
            return this.requestCreator.createDownloadRequestWithDownloadedBytesHeader(url, fileSize.currentSize(), fileSize.totalSize());
        }
        return this.requestCreator.createDownloadRequest(url);
    }

    @Override
    public void stopDownloading() {
        this.canDownload = false;
    }
}

