/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.LogHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class Logger {
    private static final int DOT_CLASS = 5;
    private static final int STACK_DEPTH = 4;
    private static final List<LogHandle> HANDLES = new ArrayList<LogHandle>();

    private Logger() {
    }

    static void attach(LogHandle handle) {
        HANDLES.add(handle);
    }

    static void detach(LogHandle handle) {
        HANDLES.remove(handle);
    }

    static void detachAll() {
        HANDLES.clear();
    }

    public static void v(Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.v(Logger.getDetailedLog(message));
        }
    }

    public static void i(Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.i(Logger.getDetailedLog(message));
        }
    }

    public static void d(Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.d(Logger.getDetailedLog(message));
        }
    }

    public static void d(Throwable throwable, Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.d(throwable, Logger.getDetailedLog(message));
        }
    }

    public static void w(Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.w(Logger.getDetailedLog(message));
        }
    }

    public static void w(Throwable throwable, Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.w(throwable, Logger.getDetailedLog(message));
        }
    }

    public static void e(Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.e(Logger.getDetailedLog(message));
        }
    }

    public static void e(Throwable throwable, Object ... message) {
        for (int i = 0; i < HANDLES.size(); ++i) {
            LogHandle handle = HANDLES.get(i);
            handle.e(throwable, Logger.getDetailedLog(message));
        }
    }

    private static Object[] getDetailedLog(Object ... message) {
        Thread currentThread = Thread.currentThread();
        StackTraceElement trace = currentThread.getStackTrace()[4];
        String filename = trace.getFileName();
        String linkableSourcePosition = String.format(Locale.UK, "(%s.java:%d)", filename.substring(0, filename.length() - 5), trace.getLineNumber());
        String logPrefix = String.format("[%s][%s.%s] ", currentThread.getName(), linkableSourcePosition, trace.getMethodName());
        Object[] detailedMessage = new Object[message.length + 1];
        detailedMessage[0] = logPrefix;
        System.arraycopy(message, 0, detailedMessage, 1, message.length);
        return detailedMessage;
    }
}

