/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.InternalFileSize;

class LiteFileSize
implements InternalFileSize {
    private static final int ZERO_BYTES = 0;
    private long currentSize;
    private long totalSize;

    LiteFileSize(long currentSize, long totalSize) {
        this.currentSize = currentSize;
        this.totalSize = totalSize;
    }

    @Override
    public boolean isTotalSizeUnknown() {
        return this.totalSize <= 0L;
    }

    @Override
    public boolean isTotalSizeKnown() {
        return this.totalSize > 0L;
    }

    @Override
    public boolean areBytesDownloadedKnown() {
        return this.currentSize > 0L;
    }

    @Override
    public long currentSize() {
        return this.currentSize;
    }

    @Override
    public long totalSize() {
        return this.totalSize;
    }

    @Override
    public long remainingSize() {
        return this.totalSize - this.currentSize;
    }

    @Override
    public void addToCurrentSize(long newBytes) {
        this.currentSize += newBytes;
    }

    @Override
    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public void setCurrentSize(long currentSize) {
        this.currentSize = currentSize;
    }

    @Override
    public LiteFileSize copy() {
        return new LiteFileSize(this.currentSize, this.totalSize);
    }

    public String toString() {
        return "LiteFileSize{currentSize=" + this.currentSize + ", totalSize=" + this.totalSize + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteFileSize that = (LiteFileSize)o;
        if (this.currentSize != that.currentSize) {
            return false;
        }
        return this.totalSize == that.totalSize;
    }

    public int hashCode() {
        int result = (int)(this.currentSize ^ this.currentSize >>> 32);
        result = 31 * result + (int)(this.totalSize ^ this.totalSize >>> 32);
        return result;
    }
}

