/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.content.Context;
import com.evernote.android.job.JobCreator;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobRequest;
import com.novoda.downloadmanager.ConnectionType;
import com.novoda.downloadmanager.DownloadsNetworkRecovery;
import com.novoda.downloadmanager.LiteDownloadManager;
import com.novoda.downloadmanager.LiteJobCreator;
import com.novoda.downloadmanager.Logger;
import java.util.concurrent.TimeUnit;

class LiteDownloadsNetworkRecoveryEnabled
implements DownloadsNetworkRecovery {
    private static final long ONE_SECOND_IN_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final long FIVE_MINUTES_IN_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final boolean ENFORCE_NETWORK_REQUIREMENTS = true;
    private ConnectionType connectionType;

    LiteDownloadsNetworkRecoveryEnabled(Context context, LiteDownloadManager liteDownloadManager, ConnectionType connectionType) {
        this.connectionType = connectionType;
        JobManager jobManager = JobManager.create((Context)context);
        jobManager.addJobCreator((JobCreator)new LiteJobCreator(liteDownloadManager));
    }

    @Override
    public void scheduleRecovery() {
        JobRequest.Builder builder = new JobRequest.Builder("download-manager-reschedule").setExecutionWindow(ONE_SECOND_IN_MILLIS, FIVE_MINUTES_IN_MILLIS).setRequirementsEnforced(true);
        switch (this.connectionType) {
            case ALL: {
                builder.setRequiredNetworkType(JobRequest.NetworkType.CONNECTED);
                break;
            }
            case UNMETERED: {
                builder.setRequiredNetworkType(JobRequest.NetworkType.UNMETERED);
                break;
            }
            case METERED: {
                builder.setRequiredNetworkType(JobRequest.NetworkType.METERED);
                break;
            }
            default: {
                Logger.w("Unknown ConnectionType: " + (Object)((Object)this.connectionType));
            }
        }
        JobRequest jobRequest = builder.build();
        JobManager jobManager = JobManager.instance();
        jobManager.cancelAllForTag("download-manager-reschedule");
        jobManager.schedule(jobRequest);
        Logger.v("Scheduling Network Recovery.");
    }

    @Override
    public void updateAllowedConnectionType(ConnectionType allowedConnectionType) {
        this.connectionType = allowedConnectionType;
    }
}

