/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.app.Notification;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import com.novoda.downloadmanager.DownloadBatch;
import com.novoda.downloadmanager.DownloadBatchStatusCallback;
import com.novoda.downloadmanager.DownloadService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class LiteDownloadService
extends Service
implements DownloadService {
    private static final long TEN_MINUTES_IN_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    private static final String WAKELOCK_TAG = "liteDownloadService:wakelocktag";
    private ExecutorService executor;
    private IBinder binder;
    private PowerManager.WakeLock wakeLock;

    public void onCreate() {
        super.onCreate();
        this.executor = Executors.newSingleThreadExecutor();
        this.binder = new DownloadServiceBinder();
    }

    @Override
    public void start(int id, Notification notification) {
        this.startForeground(id, notification);
    }

    @Override
    public void stop(boolean removeNotification) {
        this.stopForeground(removeNotification);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    @Override
    public void download(DownloadBatch downloadBatch, DownloadBatchStatusCallback callback) {
        callback.onUpdate(downloadBatch.status().copy());
        downloadBatch.setCallback(callback);
        this.executor.execute(() -> {
            this.acquireCpuWakeLock();
            downloadBatch.persist();
            downloadBatch.download();
            this.releaseHeldCpuWakeLock();
        });
    }

    private void acquireCpuWakeLock() {
        PowerManager powerManager = (PowerManager)this.getSystemService("power");
        if (powerManager != null) {
            this.wakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
            this.wakeLock.acquire(TEN_MINUTES_IN_MILLIS);
        }
    }

    private void releaseHeldCpuWakeLock() {
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    public void onDestroy() {
        this.executor.shutdown();
        super.onDestroy();
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
    }

    class DownloadServiceBinder
    extends Binder {
        DownloadServiceBinder() {
        }

        DownloadService getService() {
            return LiteDownloadService.this;
        }
    }
}

