/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.os.Handler;
import com.novoda.downloadmanager.Batch;
import com.novoda.downloadmanager.CallbackThrottleCreator;
import com.novoda.downloadmanager.CompletedDownloadBatch;
import com.novoda.downloadmanager.ConnectionChecker;
import com.novoda.downloadmanager.DownloadBatch;
import com.novoda.downloadmanager.DownloadBatchFactory;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchRequirementRule;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchStatusCallback;
import com.novoda.downloadmanager.DownloadBatchStatusFilter;
import com.novoda.downloadmanager.DownloadBatchStatusNotificationDispatcher;
import com.novoda.downloadmanager.DownloadService;
import com.novoda.downloadmanager.DownloadsBatchPersistence;
import com.novoda.downloadmanager.DownloadsFilePersistence;
import com.novoda.downloadmanager.FileOperations;
import com.novoda.downloadmanager.InternalDownloadBatchStatus;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.Wait;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

class LiteDownloadManagerDownloader {
    private final Object waitForDownloadService;
    private final Object waitForDownloadBatchStatusCallback;
    private final ExecutorService executor;
    private final Handler callbackHandler;
    private final FileOperations fileOperations;
    private final DownloadsBatchPersistence downloadsBatchPersistence;
    private final DownloadsFilePersistence downloadsFilePersistence;
    private final DownloadBatchStatusNotificationDispatcher notificationDispatcher;
    private final DownloadBatchRequirementRule downloadBatchRequirementRule;
    private final Set<DownloadBatchStatusCallback> callbacks;
    private final ConnectionChecker connectionChecker;
    private final CallbackThrottleCreator callbackThrottleCreator;
    private final DownloadBatchStatusFilter downloadBatchStatusFilter;
    private final Wait.Criteria serviceCriteria;
    private DownloadService downloadService;

    LiteDownloadManagerDownloader(Object waitForDownloadService, Object waitForDownloadBatchStatusCallback, ExecutorService executor, Handler callbackHandler, FileOperations fileOperations, DownloadsBatchPersistence downloadsBatchPersistence, DownloadsFilePersistence downloadsFilePersistence, DownloadBatchStatusNotificationDispatcher notificationDispatcher, DownloadBatchRequirementRule downloadBatchRequirementRule, ConnectionChecker connectionChecker, Set<DownloadBatchStatusCallback> callbacks, CallbackThrottleCreator callbackThrottleCreator, DownloadBatchStatusFilter downloadBatchStatusFilter, Wait.Criteria serviceCriteria) {
        this.waitForDownloadService = waitForDownloadService;
        this.waitForDownloadBatchStatusCallback = waitForDownloadBatchStatusCallback;
        this.executor = executor;
        this.callbackHandler = callbackHandler;
        this.fileOperations = fileOperations;
        this.downloadsBatchPersistence = downloadsBatchPersistence;
        this.downloadsFilePersistence = downloadsFilePersistence;
        this.notificationDispatcher = notificationDispatcher;
        this.downloadBatchRequirementRule = downloadBatchRequirementRule;
        this.connectionChecker = connectionChecker;
        this.callbacks = callbacks;
        this.callbackThrottleCreator = callbackThrottleCreator;
        this.downloadBatchStatusFilter = downloadBatchStatusFilter;
        this.serviceCriteria = serviceCriteria;
    }

    void download(Batch batch, Map<DownloadBatchId, DownloadBatch> downloadBatchMap) {
        DownloadBatch downloadBatch = DownloadBatchFactory.newInstance(batch, this.fileOperations, this.downloadsBatchPersistence, this.downloadsFilePersistence, this.callbackThrottleCreator.create(), this.connectionChecker, this.downloadBatchRequirementRule);
        this.executor.submit(downloadBatch::updateTotalSize);
        this.download(downloadBatch, downloadBatchMap);
    }

    void download(DownloadBatch downloadBatch, final Map<DownloadBatchId, DownloadBatch> downloadBatchMap) {
        DownloadBatchId downloadBatchId = downloadBatch.getId();
        if (!downloadBatchMap.containsKey(downloadBatchId)) {
            downloadBatchMap.put(downloadBatchId, downloadBatch);
        }
        final DownloadBatch batchToDownload = downloadBatchMap.get(downloadBatchId);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                Wait.waitFor(LiteDownloadManagerDownloader.this.serviceCriteria, LiteDownloadManagerDownloader.this.waitForDownloadService).thenPerform(LiteDownloadManagerDownloader.this.executeDownload(batchToDownload, downloadBatchMap));
            }
        });
    }

    private Wait.ThenPerform.Action<Void> executeDownload(DownloadBatch downloadBatch, Map<DownloadBatchId, DownloadBatch> downloadBatchMap) {
        return () -> {
            InternalDownloadBatchStatus downloadBatchStatus = downloadBatch.status();
            this.updateStatusToQueuedIfNeeded(downloadBatchStatus);
            downloadBatch.persistAsync();
            this.downloadService.download(downloadBatch, this.downloadBatchCallback(downloadBatchMap));
            return null;
        };
    }

    private void updateStatusToQueuedIfNeeded(InternalDownloadBatchStatus downloadBatchStatus) {
        DownloadBatchStatus.Status status = downloadBatchStatus.status();
        if (status != DownloadBatchStatus.Status.PAUSED && status != DownloadBatchStatus.Status.DOWNLOADED && status != DownloadBatchStatus.Status.DELETING && status != DownloadBatchStatus.Status.DELETED) {
            downloadBatchStatus.markAsQueued(this.downloadsBatchPersistence);
        }
    }

    private DownloadBatchStatusCallback downloadBatchCallback(Map<DownloadBatchId, DownloadBatch> downloadBatchMap) {
        return downloadBatchStatus -> {
            if (downloadBatchStatus == null || this.downloadBatchStatusFilter.shouldFilterOut(downloadBatchStatus)) {
                return;
            }
            DownloadBatchId downloadBatchId = downloadBatchStatus.getDownloadBatchId();
            if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETED) {
                Logger.v("batch " + downloadBatchId.rawId() + " is finally deleted, removing it from the map");
                downloadBatchMap.remove(downloadBatchId);
            }
            this.callbackHandler.post(() -> {
                Object object = this.waitForDownloadBatchStatusCallback;
                synchronized (object) {
                    for (DownloadBatchStatusCallback callback : this.callbacks) {
                        callback.onUpdate(downloadBatchStatus);
                    }
                    this.notificationDispatcher.updateNotification(downloadBatchStatus);
                }
            });
        };
    }

    void setDownloadService(DownloadService downloadService) {
        this.downloadService = downloadService;
        this.notificationDispatcher.setDownloadService(downloadService);
    }

    public boolean addCompletedBatch(CompletedDownloadBatch completedDownloadBatch, Map<DownloadBatchId, DownloadBatch> downloadBatchMap) {
        DownloadBatch downloadBatch = DownloadBatchFactory.newInstance(completedDownloadBatch.asBatch(), this.fileOperations, this.downloadsBatchPersistence, this.downloadsFilePersistence, this.callbackThrottleCreator.create(), this.connectionChecker, this.downloadBatchRequirementRule);
        downloadBatchMap.put(downloadBatch.getId(), downloadBatch);
        return this.downloadsBatchPersistence.persistCompletedBatch(completedDownloadBatch);
    }
}

