/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.novoda.downloadmanager.AllBatchStatusesCallback;
import com.novoda.downloadmanager.AllStoredDownloadsSubmittedCallback;
import com.novoda.downloadmanager.Batch;
import com.novoda.downloadmanager.CompletedDownloadBatch;
import com.novoda.downloadmanager.ConnectionChecker;
import com.novoda.downloadmanager.ConnectionType;
import com.novoda.downloadmanager.DownloadBatch;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchStatusCallback;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileStatus;
import com.novoda.downloadmanager.DownloadFileStatusCallback;
import com.novoda.downloadmanager.DownloadManager;
import com.novoda.downloadmanager.DownloadService;
import com.novoda.downloadmanager.DownloadsBatchPersistence;
import com.novoda.downloadmanager.DownloadsNetworkRecoveryCreator;
import com.novoda.downloadmanager.FileOperations;
import com.novoda.downloadmanager.LiteDownloadManagerDownloader;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.Wait;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

class LiteDownloadManager
implements DownloadManager {
    private final Object waitForDownloadService;
    private final Object waitForDownloadBatchStatusCallback;
    private final ExecutorService executor;
    private final Handler callbackHandler;
    private final Map<DownloadBatchId, DownloadBatch> downloadBatchMap;
    private final Set<DownloadBatchStatusCallback> callbacks;
    private final FileOperations fileOperations;
    private final DownloadsBatchPersistence downloadsBatchPersistence;
    private final LiteDownloadManagerDownloader downloader;
    private final ConnectionChecker connectionChecker;
    private final Wait.Criteria serviceCriteria;

    LiteDownloadManager(Object waitForDownloadService, Object waitForDownloadBatchStatusCallback, ExecutorService executor, Handler callbackHandler, Map<DownloadBatchId, DownloadBatch> downloadBatchMap, Set<DownloadBatchStatusCallback> callbacks, FileOperations fileOperations, DownloadsBatchPersistence downloadsBatchPersistence, LiteDownloadManagerDownloader downloader, ConnectionChecker connectionChecker, Wait.Criteria serviceCriteria) {
        this.waitForDownloadService = waitForDownloadService;
        this.waitForDownloadBatchStatusCallback = waitForDownloadBatchStatusCallback;
        this.executor = executor;
        this.callbackHandler = callbackHandler;
        this.downloadBatchMap = downloadBatchMap;
        this.callbacks = callbacks;
        this.fileOperations = fileOperations;
        this.downloadsBatchPersistence = downloadsBatchPersistence;
        this.downloader = downloader;
        this.connectionChecker = connectionChecker;
        this.serviceCriteria = serviceCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialise(DownloadService downloadService) {
        this.downloader.setDownloadService(downloadService);
        this.serviceCriteria.update(downloadService);
        Object object = this.waitForDownloadService;
        synchronized (object) {
            this.waitForDownloadService.notifyAll();
        }
    }

    @Override
    public void submitAllStoredDownloads(AllStoredDownloadsSubmittedCallback callback) {
        this.downloadsBatchPersistence.loadAsync(this.fileOperations, this.loadBatchesCallback(callback));
    }

    private DownloadsBatchPersistence.LoadBatchesCallback loadBatchesCallback(AllStoredDownloadsSubmittedCallback callback) {
        return downloadBatches -> {
            for (DownloadBatch downloadBatch : downloadBatches) {
                this.downloader.download(downloadBatch, this.downloadBatchMap);
            }
            this.callbackHandler.post(callback::onAllDownloadsSubmitted);
        };
    }

    @Override
    public void download(Batch batch) {
        DownloadBatchId downloadBatchId = batch.downloadBatchId();
        DownloadBatch downloadBatch = this.downloadBatchMap.get(downloadBatchId);
        if (downloadBatch == null) {
            this.downloader.download(batch, this.downloadBatchMap);
        } else {
            Logger.v("abort download batch " + downloadBatchId + " will not download as exists already in the running batches map");
        }
    }

    @Override
    public void pause(DownloadBatchId downloadBatchId) {
        DownloadBatch downloadBatch = this.downloadBatchMap.get(downloadBatchId);
        if (downloadBatch == null) {
            Logger.v("abort pause batch " + downloadBatchId + " will not be paused as it does not exists in the running batches map");
            return;
        }
        downloadBatch.pause();
    }

    @Override
    public void resume(DownloadBatchId downloadBatchId) {
        DownloadBatch downloadBatch = this.downloadBatchMap.get(downloadBatchId);
        if (downloadBatch == null) {
            Logger.v("abort resume batch " + downloadBatchId + " will not be resume as it does not exists in the running batches map");
            return;
        }
        if (downloadBatch.status().status() == DownloadBatchStatus.Status.DOWNLOADING) {
            Logger.v("abort resume batch " + downloadBatchId + " will not be resume as it's already downloading");
            return;
        }
        downloadBatch.resume();
        this.downloader.download(downloadBatch, this.downloadBatchMap);
    }

    @Override
    public void delete(DownloadBatchId downloadBatchId) {
        DownloadBatch downloadBatch = this.downloadBatchMap.get(downloadBatchId);
        if (downloadBatch == null) {
            Logger.v("abort delete batch " + downloadBatchId + " will not be deleted as it does not exists in the running batches map");
            return;
        }
        downloadBatch.delete();
        this.downloadBatchMap.remove(downloadBatchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDownloadBatchCallback(DownloadBatchStatusCallback downloadBatchCallback) {
        Object object = this.waitForDownloadBatchStatusCallback;
        synchronized (object) {
            this.callbacks.add(downloadBatchCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownloadBatchCallback(DownloadBatchStatusCallback downloadBatchCallback) {
        Object object = this.waitForDownloadBatchStatusCallback;
        synchronized (object) {
            if (this.callbacks.contains(downloadBatchCallback)) {
                this.callbacks.remove(downloadBatchCallback);
            }
        }
    }

    @Override
    @WorkerThread
    public List<DownloadBatchStatus> getAllDownloadBatchStatuses() {
        return Wait.waitFor(this.serviceCriteria, this.waitForDownloadService).thenPerform(this::executeGetAllDownloadBatchStatuses);
    }

    private List<DownloadBatchStatus> executeGetAllDownloadBatchStatuses() {
        ArrayList<DownloadBatchStatus> downloadBatchStatuses = new ArrayList<DownloadBatchStatus>(this.downloadBatchMap.size());
        for (DownloadBatch downloadBatch : this.downloadBatchMap.values()) {
            downloadBatchStatuses.add(downloadBatch.status());
        }
        return downloadBatchStatuses;
    }

    @Override
    public void getAllDownloadBatchStatuses(AllBatchStatusesCallback callback) {
        this.executor.submit(() -> Wait.waitFor(this.serviceCriteria, this.waitForDownloadService).thenPerform(() -> {
            List<DownloadBatchStatus> downloadBatchStatuses = this.executeGetAllDownloadBatchStatuses();
            this.callbackHandler.post(() -> callback.onReceived(downloadBatchStatuses));
            return null;
        }));
    }

    @Override
    @Nullable
    @WorkerThread
    public DownloadFileStatus getDownloadFileStatusWithMatching(DownloadBatchId downloadBatchId, DownloadFileId downloadFileId) {
        return Wait.waitFor(this.serviceCriteria, this.waitForDownloadService).thenPerform(() -> this.executeGetDownloadStatusWithMatching(downloadBatchId, downloadFileId));
    }

    @Nullable
    private DownloadFileStatus executeGetDownloadStatusWithMatching(DownloadBatchId downloadBatchId, DownloadFileId downloadFileId) {
        DownloadBatch downloadBatch = this.downloadBatchMap.get(downloadBatchId);
        if (downloadBatch == null) {
            return null;
        }
        DownloadFileStatus downloadFileStatus = downloadBatch.downloadFileStatusWith(downloadFileId);
        if (downloadFileStatus == null) {
            return null;
        }
        return downloadFileStatus;
    }

    @Override
    public void getDownloadFileStatusWithMatching(DownloadBatchId downloadBatchId, DownloadFileId downloadFileId, DownloadFileStatusCallback callback) {
        this.executor.submit(() -> Wait.waitFor(this.serviceCriteria, this.waitForDownloadService).thenPerform(() -> {
            DownloadFileStatus downloadFileStatus = this.executeGetDownloadStatusWithMatching(downloadBatchId, downloadFileId);
            this.callbackHandler.post(() -> callback.onReceived(downloadFileStatus));
            return null;
        }));
    }

    @Override
    public void updateAllowedConnectionType(ConnectionType allowedConnectionType) {
        if (allowedConnectionType == null) {
            throw new IllegalArgumentException("Allowed connection type cannot be null");
        }
        this.connectionChecker.updateAllowedConnectionType(allowedConnectionType);
        DownloadsNetworkRecoveryCreator.getInstance().updateAllowedConnectionType(allowedConnectionType);
        if (this.connectionChecker.isAllowedToDownload()) {
            this.submitAllStoredDownloads(() -> Logger.v("Allowed connectionType updated to " + (Object)((Object)allowedConnectionType) + ". All jobs submitted"));
        } else {
            for (DownloadBatch downloadBatch : this.downloadBatchMap.values()) {
                downloadBatch.waitForNetwork();
            }
        }
    }

    @Override
    @WorkerThread
    public boolean addCompletedBatch(CompletedDownloadBatch completedDownloadBatch) throws IllegalArgumentException {
        if (this.alreadyContainsBatch(completedDownloadBatch)) {
            Logger.w("CompletedDownloadBatch with id: " + completedDownloadBatch.downloadBatchId() + " already exists.");
            return false;
        }
        return this.downloader.addCompletedBatch(completedDownloadBatch, this.downloadBatchMap);
    }

    private boolean alreadyContainsBatch(CompletedDownloadBatch completedDownloadBatch) {
        return this.downloadBatchMap.containsKey(completedDownloadBatch.downloadBatchId());
    }
}

