/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileStatus;
import com.novoda.downloadmanager.FilePath;
import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.InternalDownloadFileStatus;
import com.novoda.downloadmanager.Optional;

class LiteDownloadFileStatus
implements InternalDownloadFileStatus {
    private final DownloadBatchId downloadBatchId;
    private final DownloadFileId downloadFileId;
    private FileSize fileSize;
    private FilePath localFilePath;
    private DownloadFileStatus.Status status;
    private Optional<DownloadError> downloadError = Optional.absent();

    LiteDownloadFileStatus(DownloadBatchId downloadBatchId, DownloadFileId downloadFileId, DownloadFileStatus.Status status, FileSize fileSize, FilePath localFilePath) {
        this.downloadBatchId = downloadBatchId;
        this.downloadFileId = downloadFileId;
        this.status = status;
        this.fileSize = fileSize;
        this.localFilePath = localFilePath;
    }

    @Override
    public void update(FileSize fileSize, FilePath localFilePath) {
        this.fileSize = fileSize;
        this.localFilePath = localFilePath;
        if (fileSize.currentSize() == fileSize.totalSize()) {
            this.markAsDownloaded();
        }
    }

    private void markAsDownloaded() {
        this.status = DownloadFileStatus.Status.DOWNLOADED;
    }

    @Override
    public long bytesDownloaded() {
        return this.fileSize.currentSize();
    }

    @Override
    public long totalBytes() {
        return this.fileSize.totalSize();
    }

    @Override
    public FilePath localFilePath() {
        return this.localFilePath;
    }

    @Override
    public DownloadBatchId downloadBatchId() {
        return this.downloadBatchId;
    }

    @Override
    public DownloadFileId downloadFileId() {
        return this.downloadFileId;
    }

    @Override
    public boolean isMarkedAsDownloading() {
        return this.status == DownloadFileStatus.Status.DOWNLOADING;
    }

    @Override
    public boolean isMarkedAsQueued() {
        return this.status == DownloadFileStatus.Status.QUEUED;
    }

    @Override
    public boolean isMarkedAsDeleted() {
        return this.status == DownloadFileStatus.Status.DELETED;
    }

    @Override
    public void markAsDownloading() {
        this.status = DownloadFileStatus.Status.DOWNLOADING;
    }

    @Override
    public void markAsPaused() {
        this.status = DownloadFileStatus.Status.PAUSED;
    }

    @Override
    public boolean isMarkedAsError() {
        return this.status == DownloadFileStatus.Status.ERROR;
    }

    @Override
    public void markAsQueued() {
        this.status = DownloadFileStatus.Status.QUEUED;
    }

    @Override
    public void markAsDeleted() {
        this.status = DownloadFileStatus.Status.DELETED;
    }

    @Override
    public void markAsError(DownloadError downloadError) {
        this.status = DownloadFileStatus.Status.ERROR;
        this.downloadError = Optional.of(downloadError);
    }

    @Override
    public boolean isMarkedAsWaitingForNetwork() {
        return this.status == DownloadFileStatus.Status.WAITING_FOR_NETWORK;
    }

    @Override
    public void waitForNetwork() {
        this.status = DownloadFileStatus.Status.WAITING_FOR_NETWORK;
    }

    @Override
    public Optional<DownloadError> error() {
        return this.downloadError;
    }

    @Override
    public DownloadFileStatus.Status status() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteDownloadFileStatus that = (LiteDownloadFileStatus)o;
        if (this.downloadBatchId != null ? !this.downloadBatchId.equals(that.downloadBatchId) : that.downloadBatchId != null) {
            return false;
        }
        if (this.downloadFileId != null ? !this.downloadFileId.equals(that.downloadFileId) : that.downloadFileId != null) {
            return false;
        }
        if (this.fileSize != null ? !this.fileSize.equals(that.fileSize) : that.fileSize != null) {
            return false;
        }
        if (this.localFilePath != null ? !this.localFilePath.equals(that.localFilePath) : that.localFilePath != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        return this.downloadError != null ? this.downloadError.equals(that.downloadError) : that.downloadError == null;
    }

    public int hashCode() {
        int result = this.downloadBatchId != null ? this.downloadBatchId.hashCode() : 0;
        result = 31 * result + (this.downloadFileId != null ? this.downloadFileId.hashCode() : 0);
        result = 31 * result + (this.fileSize != null ? this.fileSize.hashCode() : 0);
        result = 31 * result + (this.localFilePath != null ? this.localFilePath.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.downloadError != null ? this.downloadError.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LiteDownloadFileStatus{downloadBatchId=" + this.downloadBatchId + ", downloadFileId=" + this.downloadFileId + ", fileSize=" + this.fileSize + ", localFilePath=" + this.localFilePath + ", status=" + (Object)((Object)this.status) + ", downloadError=" + this.downloadError + '}';
    }
}

