/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.Nullable;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchTitle;
import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadsBatchPersistence;
import com.novoda.downloadmanager.DownloadsBatchStatusPersistence;
import com.novoda.downloadmanager.InternalDownloadBatchStatus;
import com.novoda.downloadmanager.Optional;

class LiteDownloadBatchStatus
implements InternalDownloadBatchStatus {
    private static final long ZERO_BYTES = 0L;
    private static final int TOTAL_PERCENTAGE = 100;
    private final DownloadBatchTitle downloadBatchTitle;
    private final DownloadBatchId downloadBatchId;
    private final String storageRoot;
    private final long downloadedDateTimeInMillis;
    private DownloadBatchStatus.Status status;
    private boolean notificationSeen;
    private long bytesDownloaded;
    private long totalBatchSizeBytes;
    private int percentageDownloaded;
    private Optional<DownloadError> downloadError;

    LiteDownloadBatchStatus(DownloadBatchId downloadBatchId, DownloadBatchTitle downloadBatchTitle, String storageRoot, long downloadedDateTimeInMillis, long bytesDownloaded, long totalBatchSizeBytes, DownloadBatchStatus.Status status, boolean notificationSeen, Optional<DownloadError> downloadError) {
        this.downloadBatchTitle = downloadBatchTitle;
        this.downloadBatchId = downloadBatchId;
        this.storageRoot = storageRoot;
        this.downloadedDateTimeInMillis = downloadedDateTimeInMillis;
        this.bytesDownloaded = bytesDownloaded;
        this.totalBatchSizeBytes = totalBatchSizeBytes;
        this.downloadError = downloadError;
        this.percentageDownloaded = this.getPercentageFrom(bytesDownloaded, totalBatchSizeBytes);
        this.status = status;
        this.notificationSeen = notificationSeen;
    }

    @Override
    public long bytesDownloaded() {
        return this.bytesDownloaded;
    }

    @Override
    public long bytesTotalSize() {
        return this.totalBatchSizeBytes;
    }

    @Override
    public void updateTotalSize(long totalBatchSizeBytes) {
        this.totalBatchSizeBytes = totalBatchSizeBytes;
    }

    @Override
    public void updateDownloaded(long currentBytesDownloaded) {
        this.bytesDownloaded = currentBytesDownloaded;
        this.percentageDownloaded = this.getPercentageFrom(this.bytesDownloaded, this.totalBatchSizeBytes);
    }

    private int getPercentageFrom(long bytesDownloaded, long totalFileSizeBytes) {
        if (this.totalBatchSizeBytes <= 0L) {
            return 0;
        }
        return (int)((float)bytesDownloaded / (float)totalFileSizeBytes * 100.0f);
    }

    @Override
    public int percentageDownloaded() {
        return this.percentageDownloaded;
    }

    @Override
    public DownloadBatchId getDownloadBatchId() {
        return this.downloadBatchId;
    }

    @Override
    public DownloadBatchTitle getDownloadBatchTitle() {
        return this.downloadBatchTitle;
    }

    @Override
    public String storageRoot() {
        return this.storageRoot;
    }

    @Override
    public DownloadBatchStatus.Status status() {
        return this.status;
    }

    @Override
    public long downloadedDateTimeInMillis() {
        return this.downloadedDateTimeInMillis;
    }

    @Override
    public void markAsDownloading(DownloadsBatchStatusPersistence persistence) {
        this.status = DownloadBatchStatus.Status.DOWNLOADING;
        this.updateStatusAsync(this.status, persistence);
    }

    @Override
    public void markAsPaused(DownloadsBatchStatusPersistence persistence) {
        this.status = DownloadBatchStatus.Status.PAUSED;
        this.updateStatusAsync(this.status, persistence);
    }

    @Override
    public void markAsQueued(DownloadsBatchStatusPersistence persistence) {
        this.status = DownloadBatchStatus.Status.QUEUED;
        this.updateStatusAsync(this.status, persistence);
    }

    @Override
    public void markAsDeleting() {
        this.status = DownloadBatchStatus.Status.DELETING;
        this.notificationSeen = false;
    }

    @Override
    public void markAsDeleted() {
        this.status = DownloadBatchStatus.Status.DELETED;
        this.notificationSeen = false;
    }

    @Override
    public void markAsError(Optional<DownloadError> downloadError, DownloadsBatchStatusPersistence persistence) {
        this.status = DownloadBatchStatus.Status.ERROR;
        this.downloadError = downloadError;
        this.updateStatusAsync(this.status, persistence);
    }

    @Override
    public void markAsDownloaded(DownloadsBatchStatusPersistence persistence) {
        this.status = DownloadBatchStatus.Status.DOWNLOADED;
        this.updateStatusAsync(this.status, persistence);
    }

    @Override
    public void markAsWaitingForNetwork(DownloadsBatchPersistence persistence) {
        this.status = DownloadBatchStatus.Status.WAITING_FOR_NETWORK;
        this.updateStatusAsync(this.status, persistence);
    }

    @Override
    public InternalDownloadBatchStatus copy() {
        return new LiteDownloadBatchStatus(this.downloadBatchId, this.downloadBatchTitle, this.storageRoot, this.downloadedDateTimeInMillis, this.bytesDownloaded, this.totalBatchSizeBytes, this.status, this.notificationSeen, this.downloadError);
    }

    private void updateStatusAsync(DownloadBatchStatus.Status status, DownloadsBatchStatusPersistence persistence) {
        persistence.updateStatusAsync(this.downloadBatchId, status);
    }

    @Override
    @Nullable
    public DownloadError downloadError() {
        if (this.downloadError.isPresent()) {
            return this.downloadError.get();
        }
        return null;
    }

    @Override
    public boolean notificationSeen() {
        return this.notificationSeen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteDownloadBatchStatus that = (LiteDownloadBatchStatus)o;
        if (this.downloadedDateTimeInMillis != that.downloadedDateTimeInMillis) {
            return false;
        }
        if (this.notificationSeen != that.notificationSeen) {
            return false;
        }
        if (this.bytesDownloaded != that.bytesDownloaded) {
            return false;
        }
        if (this.totalBatchSizeBytes != that.totalBatchSizeBytes) {
            return false;
        }
        if (this.percentageDownloaded != that.percentageDownloaded) {
            return false;
        }
        if (this.downloadBatchTitle != null ? !this.downloadBatchTitle.equals(that.downloadBatchTitle) : that.downloadBatchTitle != null) {
            return false;
        }
        if (this.downloadBatchId != null ? !this.downloadBatchId.equals(that.downloadBatchId) : that.downloadBatchId != null) {
            return false;
        }
        if (this.storageRoot != null ? !this.storageRoot.equals(that.storageRoot) : that.storageRoot != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        return this.downloadError != null ? this.downloadError.equals(that.downloadError) : that.downloadError == null;
    }

    public int hashCode() {
        int result = this.downloadBatchTitle != null ? this.downloadBatchTitle.hashCode() : 0;
        result = 31 * result + (this.downloadBatchId != null ? this.downloadBatchId.hashCode() : 0);
        result = 31 * result + (this.storageRoot != null ? this.storageRoot.hashCode() : 0);
        result = 31 * result + (int)(this.downloadedDateTimeInMillis ^ this.downloadedDateTimeInMillis >>> 32);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.notificationSeen ? 1 : 0);
        result = 31 * result + (int)(this.bytesDownloaded ^ this.bytesDownloaded >>> 32);
        result = 31 * result + (int)(this.totalBatchSizeBytes ^ this.totalBatchSizeBytes >>> 32);
        result = 31 * result + this.percentageDownloaded;
        result = 31 * result + (this.downloadError != null ? this.downloadError.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LiteDownloadBatchStatus{downloadBatchTitle=" + this.downloadBatchTitle + ", downloadBatchId=" + this.downloadBatchId + ", storageRoot='" + this.storageRoot + '\'' + ", downloadedDateTimeInMillis=" + this.downloadedDateTimeInMillis + ", status=" + (Object)((Object)this.status) + ", notificationSeen=" + this.notificationSeen + ", bytesDownloaded=" + this.bytesDownloaded + ", totalBatchSizeBytes=" + this.totalBatchSizeBytes + ", percentageDownloaded=" + this.percentageDownloaded + ", downloadError=" + this.downloadError + '}';
    }
}

