/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.BatchBuilder;
import com.novoda.downloadmanager.BatchFile;
import com.novoda.downloadmanager.BatchFileBuilder;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.FileNameExtractor;
import com.novoda.downloadmanager.InternalBatchBuilder;
import com.novoda.downloadmanager.InternalBatchFileBuilder;
import com.novoda.downloadmanager.Optional;
import com.novoda.downloadmanager.StorageRoot;
import java.io.File;

final class LiteBatchFileBuilder
implements InternalBatchFileBuilder {
    private final StorageRoot storageRoot;
    private final DownloadBatchId downloadBatchId;
    private final String networkAddress;
    private Optional<DownloadFileId> downloadFileId = Optional.absent();
    private Optional<String> path = Optional.absent();
    private Optional<String> fileName = Optional.absent();
    private InternalBatchBuilder parentBuilder;

    LiteBatchFileBuilder(StorageRoot storageRoot, DownloadBatchId downloadBatchId, String networkAddress) {
        this.storageRoot = storageRoot;
        this.downloadBatchId = downloadBatchId;
        this.networkAddress = networkAddress;
    }

    @Override
    public BatchFileBuilder withParentBuilder(InternalBatchBuilder parentBuilder) {
        this.parentBuilder = parentBuilder;
        return this;
    }

    @Override
    public BatchFileBuilder withIdentifier(DownloadFileId downloadFileId) {
        this.downloadFileId = Optional.fromNullable(downloadFileId);
        return this;
    }

    @Override
    public BatchFileBuilder saveTo(String path) {
        String networkAddressDerivedFileName = FileNameExtractor.extractFrom(this.networkAddress);
        return this.saveTo(path, networkAddressDerivedFileName);
    }

    @Override
    public BatchFileBuilder saveTo(String path, String fileName) {
        this.path = Optional.fromNullable(path).filterNot("/"::equals);
        this.fileName = Optional.fromNullable(fileName);
        return this;
    }

    @Override
    public BatchBuilder apply() {
        String absolutePath = this.storageRoot.path() + File.separator + this.downloadBatchId.rawId() + File.separator + this.path.map(it -> it + File.separator).or("") + this.fileName.getOrElse(() -> FileNameExtractor.extractFrom(this.networkAddress));
        this.parentBuilder.withFile(new BatchFile(this.networkAddress, this.downloadFileId, absolutePath));
        return this.parentBuilder;
    }
}

