/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.Batch;
import com.novoda.downloadmanager.BatchFile;
import com.novoda.downloadmanager.BatchFileBuilder;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.FallbackDownloadFileIdProvider;
import com.novoda.downloadmanager.InternalBatchBuilder;
import com.novoda.downloadmanager.StorageRoot;
import java.util.HashSet;
import java.util.List;

final class LiteBatchBuilder
implements InternalBatchBuilder {
    private final StorageRoot storageRoot;
    private final DownloadBatchId downloadBatchId;
    private final String title;
    private final List<BatchFile> batchFiles;

    LiteBatchBuilder(StorageRoot storageRoot, DownloadBatchId downloadBatchId, String title, List<BatchFile> batchFiles) {
        this.storageRoot = storageRoot;
        this.downloadBatchId = downloadBatchId;
        this.title = title;
        this.batchFiles = batchFiles;
    }

    @Override
    public void withFile(BatchFile batchFile) {
        this.batchFiles.add(batchFile);
    }

    @Override
    public BatchFileBuilder downloadFrom(String networkAddress) {
        return BatchFile.from(this.storageRoot, this.downloadBatchId, networkAddress).withParentBuilder(this);
    }

    @Override
    public Batch build() {
        this.ensureNoFileIdDuplicates(this.batchFiles);
        return new Batch(this.storageRoot, this.downloadBatchId, this.title, this.batchFiles);
    }

    private void ensureNoFileIdDuplicates(List<BatchFile> batchFiles) {
        HashSet<DownloadFileId> rawIdsWithoutDuplicates = new HashSet<DownloadFileId>();
        for (BatchFile batchFile : batchFiles) {
            rawIdsWithoutDuplicates.add(FallbackDownloadFileIdProvider.downloadFileIdFor(this.downloadBatchId, batchFile));
        }
        if (rawIdsWithoutDuplicates.size() != batchFiles.size()) {
            throw new IllegalArgumentException(String.format("Duplicated file for batch %s (batchId: %s)", this.title, this.downloadBatchId.rawId()));
        }
    }
}

