/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.ActionScheduler;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

class FixedRateTimerActionScheduler
implements ActionScheduler {
    private static final long DELAY_IN_MILLIS = 0L;
    private final Timer timer;
    private final long frequencyInMillis;
    private final Map<ActionScheduler.Action, TimerTask> actionTimerTasks;

    FixedRateTimerActionScheduler(Timer timer, long frequencyInMillis, Map<ActionScheduler.Action, TimerTask> actionTimerTasks) {
        this.timer = timer;
        this.frequencyInMillis = frequencyInMillis;
        this.actionTimerTasks = actionTimerTasks;
    }

    @Override
    public void schedule(final ActionScheduler.Action action) {
        if (this.actionTimerTasks.containsKey(action)) {
            return;
        }
        TimerTask taskToExecute = new TimerTask(){

            @Override
            public void run() {
                action.perform();
            }
        };
        this.timer.scheduleAtFixedRate(taskToExecute, 0L, this.frequencyInMillis);
        this.actionTimerTasks.put(action, taskToExecute);
    }

    @Override
    public void cancel(ActionScheduler.Action action) {
        if (this.actionTimerTasks.containsKey(action)) {
            TimerTask timerTask = this.actionTimerTasks.get(action);
            timerTask.cancel();
            this.actionTimerTasks.remove(action);
        }
    }

    @Override
    public void cancelAll() {
        for (Map.Entry<ActionScheduler.Action, TimerTask> timerTaskEntry : this.actionTimerTasks.entrySet()) {
            TimerTask timerTask = timerTaskEntry.getValue();
            timerTask.cancel();
        }
        this.actionTimerTasks.clear();
    }

    @Override
    public boolean isScheduled(ActionScheduler.Action action) {
        return this.actionTimerTasks.containsKey(action);
    }
}

