/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.FilePath;
import com.novoda.downloadmanager.LiteFilePath;

public final class FilePathCreator {
    private static final String EMPTY = "";
    private static final String UNKNOWN = "unknown";
    private static final FilePath UNKNOWN_FILEPATH = new LiteFilePath("unknown");

    private FilePathCreator() {
    }

    public static FilePath unknownFilePath() {
        return UNKNOWN_FILEPATH;
    }

    public static FilePath create(String basePath, String rawPath) {
        String relativePath = FilePathCreator.removeSubstring(rawPath, basePath);
        String absolutePath = basePath + relativePath;
        return new LiteFilePath(absolutePath);
    }

    public static FilePath create(String absolutePath) {
        return new LiteFilePath(absolutePath);
    }

    private static String removeSubstring(String source, String subString) {
        return source.replaceAll(subString, EMPTY);
    }
}

