/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.Nullable;
import com.novoda.downloadmanager.FileDownloader;
import com.novoda.downloadmanager.HttpClient;
import com.novoda.downloadmanager.NetworkFileDownloader;
import com.novoda.downloadmanager.NetworkRequestCreator;

class FileDownloaderCreator {
    private final FileDownloaderType type;
    @Nullable
    private final Class<? extends FileDownloader> customClass;
    @Nullable
    private final HttpClient httpClient;

    static FileDownloaderCreator newNetworkFileDownloaderCreator(HttpClient httpClient) {
        return new FileDownloaderCreator(FileDownloaderType.NETWORK, null, httpClient);
    }

    static FileDownloaderCreator newCustomFileDownloaderCreator(Class<? extends FileDownloader> customClass) {
        return new FileDownloaderCreator(FileDownloaderType.CUSTOM, customClass, null);
    }

    FileDownloaderCreator(FileDownloaderType type, @Nullable Class<? extends FileDownloader> customClass, @Nullable HttpClient httpClient) {
        this.type = type;
        this.customClass = customClass;
        this.httpClient = httpClient;
    }

    FileDownloader create() {
        FileDownloader fileDownloader;
        switch (this.type) {
            case NETWORK: {
                NetworkRequestCreator requestCreator = new NetworkRequestCreator();
                fileDownloader = new NetworkFileDownloader(this.httpClient, requestCreator);
                break;
            }
            case CUSTOM: {
                fileDownloader = this.createCustomFileDownloader();
                break;
            }
            default: {
                throw new IllegalStateException("FileDownloader of type " + (Object)((Object)this.type) + " is not supported");
            }
        }
        return fileDownloader;
    }

    private FileDownloader createCustomFileDownloader() {
        if (this.customClass == null) {
            throw new CustomFileDownloaderException("CustomFileDownloader class cannot be accessed, is it public?");
        }
        try {
            ClassLoader systemClassLoader = this.getClass().getClassLoader();
            Class<?> customFileDownloaderClass = systemClassLoader.loadClass(this.customClass.getCanonicalName());
            return (FileDownloader)customFileDownloaderClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new CustomFileDownloaderException(this.customClass, "Class cannot be accessed, is it public?", e);
        }
        catch (ClassNotFoundException e) {
            throw new CustomFileDownloaderException(this.customClass, "Class does not exist", e);
        }
        catch (InstantiationException e) {
            throw new CustomFileDownloaderException(this.customClass, "Class cannot be instantiated", e);
        }
    }

    private static class CustomFileDownloaderException
    extends RuntimeException {
        CustomFileDownloaderException(Class customClass, String message, Exception cause) {
            super(customClass.getSimpleName() + ": " + message, cause);
        }

        CustomFileDownloaderException(String message) {
            super(message);
        }
    }

    static enum FileDownloaderType {
        NETWORK,
        CUSTOM;

    }
}

