/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.database.sqlite.SQLiteConstraintException;
import android.support.annotation.WorkerThread;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadFile;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileStatus;
import com.novoda.downloadmanager.DownloadsFilePersisted;
import com.novoda.downloadmanager.DownloadsPersistence;
import com.novoda.downloadmanager.FileDownloader;
import com.novoda.downloadmanager.FileDownloaderCreator;
import com.novoda.downloadmanager.FileOperations;
import com.novoda.downloadmanager.FilePath;
import com.novoda.downloadmanager.FilePersistence;
import com.novoda.downloadmanager.FilePersistenceCreator;
import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.FileSizeRequester;
import com.novoda.downloadmanager.InternalFileSize;
import com.novoda.downloadmanager.InternalFileSizeCreator;
import com.novoda.downloadmanager.LiteDownloadFileStatus;
import com.novoda.downloadmanager.LiteDownloadsFilePersisted;
import com.novoda.downloadmanager.Logger;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

class DownloadsFilePersistence {
    private final DownloadsPersistence downloadsPersistence;

    DownloadsFilePersistence(DownloadsPersistence downloadsPersistence) {
        this.downloadsPersistence = downloadsPersistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    boolean persistSync(DownloadBatchId downloadBatchId, FilePath filePath, FileSize fileSize, String url, DownloadFileStatus downloadFileStatus) {
        if (downloadFileStatus.status() == DownloadFileStatus.Status.DELETED) {
            return false;
        }
        LiteDownloadsFilePersisted filePersisted = new LiteDownloadsFilePersisted(downloadBatchId, downloadFileStatus.downloadFileId(), filePath, fileSize.totalSize(), url);
        this.downloadsPersistence.startTransaction();
        try {
            this.downloadsPersistence.persistFile(filePersisted);
            this.downloadsPersistence.transactionSuccess();
            boolean bl = true;
            return bl;
        }
        catch (SQLiteConstraintException e) {
            Logger.e("failure to persist sync file " + downloadFileStatus.downloadFileId().rawId() + " with status " + (Object)((Object)downloadFileStatus.status()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.downloadsPersistence.endTransaction();
        }
    }

    List<DownloadFile> loadSync(DownloadBatchId batchId, DownloadBatchStatus.Status batchStatus, FileOperations fileOperations, DownloadsFilePersistence downloadsFilePersistence) {
        List<DownloadsFilePersisted> filePersistedList = this.downloadsPersistence.loadFiles(batchId);
        ArrayList<DownloadFile> downloadFiles = new ArrayList<DownloadFile>(filePersistedList.size());
        for (DownloadsFilePersisted filePersisted : filePersistedList) {
            DownloadFileId downloadFileId = filePersisted.downloadFileId();
            FilePersistenceCreator filePersistenceCreator = fileOperations.filePersistenceCreator();
            FilePersistence filePersistence = filePersistenceCreator.create();
            long currentSize = filePersistence.getCurrentSize(filePersisted.filePath());
            long totalFileSize = filePersisted.totalFileSize();
            InternalFileSize fileSize = InternalFileSizeCreator.createFromCurrentAndTotalSize(currentSize, totalFileSize);
            String url = filePersisted.url();
            FilePath filePath = filePersisted.filePath();
            LiteDownloadFileStatus downloadFileStatus = new LiteDownloadFileStatus(batchId, downloadFileId, this.getFileStatusFrom(batchStatus), fileSize, filePath);
            FileSizeRequester fileSizeRequester = fileOperations.fileSizeRequester();
            FileDownloaderCreator fileDownloaderCreator = fileOperations.fileDownloaderCreator();
            FileDownloader fileDownloader = fileDownloaderCreator.create();
            DownloadFile downloadFile = new DownloadFile(batchId, downloadFileId, url, downloadFileStatus, filePath, fileSize, fileDownloader, fileSizeRequester, filePersistence, downloadsFilePersistence);
            downloadFiles.add(downloadFile);
        }
        return downloadFiles;
    }

    private DownloadFileStatus.Status getFileStatusFrom(DownloadBatchStatus.Status batchStatus) {
        switch (batchStatus) {
            case QUEUED: {
                return DownloadFileStatus.Status.QUEUED;
            }
            case DOWNLOADING: {
                return DownloadFileStatus.Status.DOWNLOADING;
            }
            case PAUSED: {
                return DownloadFileStatus.Status.PAUSED;
            }
            case ERROR: {
                return DownloadFileStatus.Status.ERROR;
            }
            case DELETED: 
            case DELETING: {
                return DownloadFileStatus.Status.DELETED;
            }
            case DOWNLOADED: {
                return DownloadFileStatus.Status.DOWNLOADED;
            }
            case WAITING_FOR_NETWORK: {
                return DownloadFileStatus.Status.WAITING_FOR_NETWORK;
            }
        }
        throw new InvalidParameterException("Batch status " + (Object)((Object)batchStatus) + " is unsupported");
    }
}

