/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.database.sqlite.SQLiteConstraintException;
import android.support.annotation.WorkerThread;
import com.novoda.downloadmanager.CallbackThrottleCreator;
import com.novoda.downloadmanager.CompletedDownloadBatch;
import com.novoda.downloadmanager.ConnectionChecker;
import com.novoda.downloadmanager.DownloadBatch;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchRequirementRule;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchTitle;
import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadFile;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadsBatchPersisted;
import com.novoda.downloadmanager.DownloadsBatchStatusPersistence;
import com.novoda.downloadmanager.DownloadsFilePersistence;
import com.novoda.downloadmanager.DownloadsNotificationSeenPersistence;
import com.novoda.downloadmanager.DownloadsPersistence;
import com.novoda.downloadmanager.FileCallbackThrottle;
import com.novoda.downloadmanager.FileOperations;
import com.novoda.downloadmanager.LiteDownloadBatchStatus;
import com.novoda.downloadmanager.LiteDownloadsBatchPersisted;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;

class DownloadsBatchPersistence
implements DownloadsBatchStatusPersistence,
DownloadsNotificationSeenPersistence {
    private static final Optional<DownloadError> NO_DOWNLOAD_ERROR = Optional.absent();
    private final Executor executor;
    private final DownloadsFilePersistence downloadsFilePersistence;
    private final DownloadsPersistence downloadsPersistence;
    private final CallbackThrottleCreator callbackThrottleCreator;
    private final ConnectionChecker connectionChecker;
    private final DownloadBatchRequirementRule downloadBatchRequirementRule;

    DownloadsBatchPersistence(Executor executor, DownloadsFilePersistence downloadsFilePersistence, DownloadsPersistence downloadsPersistence, CallbackThrottleCreator callbackThrottleCreator, ConnectionChecker connectionChecker, DownloadBatchRequirementRule downloadBatchRequirementRule) {
        this.executor = executor;
        this.downloadsFilePersistence = downloadsFilePersistence;
        this.downloadsPersistence = downloadsPersistence;
        this.callbackThrottleCreator = callbackThrottleCreator;
        this.connectionChecker = connectionChecker;
        this.downloadBatchRequirementRule = downloadBatchRequirementRule;
    }

    void persistAsync(DownloadBatchTitle downloadBatchTitle, DownloadBatchId downloadBatchId, DownloadBatchStatus.Status status, List<DownloadFile> downloadFiles, long downloadedDateTimeInMillis, boolean notificationSeen, String storageRoot) {
        this.executor.execute(() -> this.persist(downloadBatchTitle, downloadBatchId, status, downloadFiles, downloadedDateTimeInMillis, notificationSeen, storageRoot));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void persist(DownloadBatchTitle downloadBatchTitle, DownloadBatchId downloadBatchId, DownloadBatchStatus.Status status, List<DownloadFile> downloadFiles, long downloadedDateTimeInMillis, boolean notificationSeen, String storageRoot) {
        ArrayList<DownloadFile> downloadFilesToPersist = new ArrayList<DownloadFile>(downloadFiles);
        this.downloadsPersistence.startTransaction();
        try {
            LiteDownloadsBatchPersisted batchPersisted = new LiteDownloadsBatchPersisted(downloadBatchTitle, downloadBatchId, status, downloadedDateTimeInMillis, notificationSeen, storageRoot);
            this.downloadsPersistence.persistBatch(batchPersisted);
            for (DownloadFile downloadFile : downloadFilesToPersist) {
                downloadFile.persist();
            }
            this.downloadsPersistence.transactionSuccess();
        }
        finally {
            this.downloadsPersistence.endTransaction();
        }
    }

    void loadAsync(FileOperations fileOperations, LoadBatchesCallback callback) {
        this.executor.execute(() -> {
            List<DownloadsBatchPersisted> batchPersistedList = this.downloadsPersistence.loadBatches();
            ArrayList<DownloadBatch> downloadBatches = new ArrayList<DownloadBatch>(batchPersistedList.size());
            for (DownloadsBatchPersisted batchPersisted : batchPersistedList) {
                try {
                    DownloadBatch downloadBatch = this.getDownloadBatch(fileOperations, batchPersisted);
                    downloadBatches.add(downloadBatch);
                }
                catch (SQLiteConstraintException e) {
                    Logger.e("exception loading async batch " + batchPersisted.downloadBatchId().rawId());
                }
            }
            callback.onLoaded(downloadBatches);
        });
    }

    private DownloadBatch getDownloadBatch(FileOperations fileOperations, DownloadsBatchPersisted batchPersisted) {
        DownloadBatchStatus.Status status = batchPersisted.downloadBatchStatus();
        DownloadBatchId downloadBatchId = batchPersisted.downloadBatchId();
        DownloadBatchTitle downloadBatchTitle = batchPersisted.downloadBatchTitle();
        long downloadedDateTimeInMillis = batchPersisted.downloadedDateTimeInMillis();
        boolean notificationSeen = batchPersisted.notificationSeen();
        String storageRoot = batchPersisted.storageRoot();
        List<DownloadFile> downloadFiles = this.downloadsFilePersistence.loadSync(downloadBatchId, status, fileOperations, this.downloadsFilePersistence);
        downloadFiles = Collections.unmodifiableList(downloadFiles);
        HashMap<DownloadFileId, Long> downloadedFileSizeMap = new HashMap<DownloadFileId, Long>(downloadFiles.size());
        long currentBytesDownloaded = 0L;
        long totalBatchSizeBytes = 0L;
        for (DownloadFile downloadFile : downloadFiles) {
            downloadedFileSizeMap.put(downloadFile.id(), downloadFile.getCurrentDownloadedBytes());
            currentBytesDownloaded += downloadFile.getCurrentDownloadedBytes();
            long totalFileSize = downloadFile.getTotalSize();
            if (totalFileSize == 0L) {
                totalBatchSizeBytes = 0L;
                currentBytesDownloaded = 0L;
                break;
            }
            totalBatchSizeBytes += totalFileSize;
        }
        LiteDownloadBatchStatus liteDownloadBatchStatus = new LiteDownloadBatchStatus(downloadBatchId, downloadBatchTitle, storageRoot, downloadedDateTimeInMillis, currentBytesDownloaded, totalBatchSizeBytes, status, notificationSeen, NO_DOWNLOAD_ERROR);
        FileCallbackThrottle fileCallbackThrottle = this.callbackThrottleCreator.create();
        return new DownloadBatch(liteDownloadBatchStatus, downloadFiles, downloadedFileSizeMap, this, fileCallbackThrottle, this.connectionChecker, this.downloadBatchRequirementRule);
    }

    void deleteAsync(DownloadBatchStatus downloadBatchStatus, DeleteCallback deleteCallback) {
        this.executor.execute(() -> {
            if (this.deleteSync(downloadBatchStatus)) {
                deleteCallback.onDeleted(downloadBatchStatus.getDownloadBatchId());
            } else {
                Logger.e("could not delete batch " + downloadBatchStatus.getDownloadBatchId().rawId() + " with status " + (Object)((Object)downloadBatchStatus.status()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    boolean deleteSync(DownloadBatchStatus downloadBatchStatus) {
        DownloadBatchId downloadBatchId = downloadBatchStatus.getDownloadBatchId();
        this.downloadsPersistence.startTransaction();
        try {
            if (this.downloadsPersistence.delete(downloadBatchId)) {
                this.downloadsPersistence.transactionSuccess();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.downloadsPersistence.endTransaction();
        }
    }

    @Override
    public void updateStatusAsync(DownloadBatchId downloadBatchId, DownloadBatchStatus.Status status) {
        this.executor.execute(() -> {
            this.downloadsPersistence.startTransaction();
            try {
                if (this.downloadsPersistence.update(downloadBatchId, status)) {
                    this.downloadsPersistence.transactionSuccess();
                } else {
                    Logger.e("could not update batch status " + (Object)((Object)status) + " failed for " + downloadBatchId.rawId());
                }
            }
            finally {
                this.downloadsPersistence.endTransaction();
            }
        });
    }

    @Override
    public void updateNotificationSeenAsync(DownloadBatchStatus downloadBatchStatus, boolean notificationSeen) {
        this.executor.execute(() -> {
            this.downloadsPersistence.startTransaction();
            try {
                if (this.downloadsPersistence.update(downloadBatchStatus.getDownloadBatchId(), notificationSeen)) {
                    this.downloadsPersistence.transactionSuccess();
                } else {
                    Logger.e("could not update notification to status " + (Object)((Object)downloadBatchStatus.status()) + " for batch id " + downloadBatchStatus.getDownloadBatchId().rawId());
                }
            }
            finally {
                this.downloadsPersistence.endTransaction();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public boolean persistCompletedBatch(CompletedDownloadBatch completedDownloadBatch) {
        this.downloadsPersistence.startTransaction();
        try {
            this.downloadsPersistence.persistCompletedBatch(completedDownloadBatch);
            this.downloadsPersistence.transactionSuccess();
            boolean bl = true;
            return bl;
        }
        catch (SQLiteConstraintException e) {
            Logger.e("failure to persist completed batch " + completedDownloadBatch.downloadBatchId());
            boolean bl = false;
            return bl;
        }
        finally {
            this.downloadsPersistence.endTransaction();
        }
    }

    static interface DeleteCallback {
        public void onDeleted(DownloadBatchId var1);
    }

    static interface LoadBatchesCallback {
        public void onLoaded(List<DownloadBatch> var1);
    }
}

