/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.app.Notification;
import android.app.NotificationChannel;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.DrawableRes;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import com.novoda.downloadmanager.CallbackThrottleCreator;
import com.novoda.downloadmanager.ConnectionChecker;
import com.novoda.downloadmanager.ConnectionType;
import com.novoda.downloadmanager.DefaultNotificationChannelProvider;
import com.novoda.downloadmanager.DownloadBatch;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadBatchRequirementRule;
import com.novoda.downloadmanager.DownloadBatchRequirementRules;
import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadBatchStatusCallback;
import com.novoda.downloadmanager.DownloadBatchStatusFilter;
import com.novoda.downloadmanager.DownloadBatchStatusNotificationCreator;
import com.novoda.downloadmanager.DownloadBatchStatusNotificationDispatcher;
import com.novoda.downloadmanager.DownloadBatchTitle;
import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadManager;
import com.novoda.downloadmanager.DownloadService;
import com.novoda.downloadmanager.DownloadsBatchPersistence;
import com.novoda.downloadmanager.DownloadsFilePersistence;
import com.novoda.downloadmanager.DownloadsNetworkRecoveryCreator;
import com.novoda.downloadmanager.DownloadsPersistence;
import com.novoda.downloadmanager.FileCallbackThrottle;
import com.novoda.downloadmanager.FileDownloader;
import com.novoda.downloadmanager.FileDownloaderCreator;
import com.novoda.downloadmanager.FileOperations;
import com.novoda.downloadmanager.FilePersistenceCreator;
import com.novoda.downloadmanager.FileSizeRequester;
import com.novoda.downloadmanager.HttpClient;
import com.novoda.downloadmanager.HttpClientFactory;
import com.novoda.downloadmanager.LiteDownloadManager;
import com.novoda.downloadmanager.LiteDownloadManagerDownloader;
import com.novoda.downloadmanager.LiteDownloadService;
import com.novoda.downloadmanager.LogHandle;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.NetworkFileSizeRequester;
import com.novoda.downloadmanager.NetworkRequestCreator;
import com.novoda.downloadmanager.NotificationChannelProvider;
import com.novoda.downloadmanager.NotificationCreator;
import com.novoda.downloadmanager.NotificationCustomizer;
import com.novoda.downloadmanager.Optional;
import com.novoda.downloadmanager.OreoNotificationChannelProvider;
import com.novoda.downloadmanager.R;
import com.novoda.downloadmanager.RoomDownloadsPersistence;
import com.novoda.downloadmanager.ServiceNotificationDispatcher;
import com.novoda.downloadmanager.StorageRequirementRule;
import com.novoda.downloadmanager.StorageRequirementRules;
import com.novoda.downloadmanager.Wait;
import com.novoda.merlin.MerlinsBeard;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class DownloadManagerBuilder {
    private static final Object SERVICE_LOCK = new Object();
    private static final Object CALLBACK_LOCK = new Object();
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private final Context applicationContext;
    private final Handler callbackHandler;
    private final FilePersistenceCreator filePersistenceCreator;
    private final StorageRequirementRules storageRequirementRules;
    private final DownloadBatchRequirementRules downloadBatchRequirementRules;
    private FileSizeRequester fileSizeRequester;
    private FileDownloaderCreator fileDownloaderCreator;
    private DownloadService downloadService;
    private LiteDownloadManager liteDownloadManager;
    private NotificationCreator<DownloadBatchStatus> notificationCreator;
    private NotificationChannelProvider notificationChannelProvider;
    private ConnectionType connectionTypeAllowed;
    private boolean allowNetworkRecovery;
    private Class<? extends FileCallbackThrottle> customCallbackThrottle;
    private DownloadsPersistence downloadsPersistence;
    private CallbackThrottleCreator.Type callbackThrottleCreatorType;
    private TimeUnit timeUnit;
    private long frequency;
    private Optional<LogHandle> logHandle;

    public static DownloadManagerBuilder newInstance(Context context, Handler callbackHandler, @DrawableRes int notificationIcon) {
        Context applicationContext = context.getApplicationContext();
        HttpClient httpClient = HttpClientFactory.getInstance();
        StorageRequirementRules storageRequirementRule = StorageRequirementRules.newInstance();
        DownloadBatchRequirementRules downloadBatchRequirementRule = DownloadBatchRequirementRules.newInstance();
        FilePersistenceCreator filePersistenceCreator = new FilePersistenceCreator(applicationContext);
        FileDownloaderCreator fileDownloaderCreator = FileDownloaderCreator.newNetworkFileDownloaderCreator(httpClient);
        NetworkRequestCreator requestCreator = new NetworkRequestCreator();
        NetworkFileSizeRequester fileSizeRequester = new NetworkFileSizeRequester(httpClient, requestCreator);
        RoomDownloadsPersistence downloadsPersistence = RoomDownloadsPersistence.newInstance(applicationContext);
        DefaultNotificationChannelProvider notificationChannelProvider = new DefaultNotificationChannelProvider(context.getResources().getString(R.string.download_notification_channel_name), context.getResources().getString(R.string.download_notification_channel_description), 2);
        DownloadNotificationCustomizer notificationCustomizer = new DownloadNotificationCustomizer(context.getResources(), notificationIcon);
        DownloadBatchStatusNotificationCreator notificationCreator = new DownloadBatchStatusNotificationCreator(context, notificationCustomizer, notificationChannelProvider);
        ConnectionType connectionTypeAllowed = ConnectionType.ALL;
        boolean allowNetworkRecovery = true;
        CallbackThrottleCreator.Type callbackThrottleCreatorType = CallbackThrottleCreator.Type.THROTTLE_BY_PROGRESS_INCREASE;
        Optional<LogHandle> logHandle = Optional.absent();
        return new DownloadManagerBuilder(applicationContext, callbackHandler, storageRequirementRule, downloadBatchRequirementRule, filePersistenceCreator, downloadsPersistence, fileSizeRequester, fileDownloaderCreator, notificationChannelProvider, notificationCreator, connectionTypeAllowed, allowNetworkRecovery, callbackThrottleCreatorType, logHandle);
    }

    private DownloadManagerBuilder(Context applicationContext, Handler callbackHandler, StorageRequirementRules storageRequirementRules, DownloadBatchRequirementRules downloadBatchRequirementRules, FilePersistenceCreator filePersistenceCreator, DownloadsPersistence downloadsPersistence, FileSizeRequester fileSizeRequester, FileDownloaderCreator fileDownloaderCreator, NotificationChannelProvider notificationChannelProvider, NotificationCreator<DownloadBatchStatus> notificationCreator, ConnectionType connectionTypeAllowed, boolean allowNetworkRecovery, CallbackThrottleCreator.Type callbackThrottleCreatorType, Optional<LogHandle> logHandle) {
        this.applicationContext = applicationContext;
        this.callbackHandler = callbackHandler;
        this.storageRequirementRules = storageRequirementRules;
        this.downloadBatchRequirementRules = downloadBatchRequirementRules;
        this.filePersistenceCreator = filePersistenceCreator;
        this.downloadsPersistence = downloadsPersistence;
        this.fileSizeRequester = fileSizeRequester;
        this.fileDownloaderCreator = fileDownloaderCreator;
        this.notificationChannelProvider = notificationChannelProvider;
        this.notificationCreator = notificationCreator;
        this.connectionTypeAllowed = connectionTypeAllowed;
        this.allowNetworkRecovery = allowNetworkRecovery;
        this.callbackThrottleCreatorType = callbackThrottleCreatorType;
        this.logHandle = logHandle;
    }

    public DownloadManagerBuilder withCustomHttpClient(HttpClient httpClient) {
        NetworkRequestCreator requestCreator = new NetworkRequestCreator();
        this.fileSizeRequester = new NetworkFileSizeRequester(httpClient, requestCreator);
        this.fileDownloaderCreator = FileDownloaderCreator.newNetworkFileDownloaderCreator(httpClient);
        return this;
    }

    public DownloadManagerBuilder withFileDownloaderCustom(FileSizeRequester fileSizeRequester, Class<? extends FileDownloader> customFileDownloaderClass) {
        this.fileSizeRequester = fileSizeRequester;
        this.fileDownloaderCreator = FileDownloaderCreator.newCustomFileDownloaderCreator(customFileDownloaderClass);
        return this;
    }

    public DownloadManagerBuilder withStorageRequirementRules(StorageRequirementRule ... storageRequirementRules) {
        for (StorageRequirementRule storageRequirementRule : storageRequirementRules) {
            this.storageRequirementRules.addRule(storageRequirementRule);
        }
        return this;
    }

    public DownloadManagerBuilder withDownloadBatchRequirementRules(DownloadBatchRequirementRule ... downloadBatchRequirementRules) {
        for (DownloadBatchRequirementRule downloadBatchRequirementRule : downloadBatchRequirementRules) {
            this.downloadBatchRequirementRules.addRule(downloadBatchRequirementRule);
        }
        return this;
    }

    public DownloadManagerBuilder withDownloadsPersistenceCustom(DownloadsPersistence downloadsPersistence) {
        this.downloadsPersistence = downloadsPersistence;
        return this;
    }

    @RequiresApi(value=26)
    public DownloadManagerBuilder withNotificationChannel(NotificationChannel notificationChannel) {
        this.notificationChannelProvider = new OreoNotificationChannelProvider(notificationChannel);
        this.notificationCreator.setNotificationChannelProvider(this.notificationChannelProvider);
        return this;
    }

    public DownloadManagerBuilder withNotificationChannel(String channelId, String name, int importance) {
        this.notificationChannelProvider = new DefaultNotificationChannelProvider(channelId, name, importance);
        this.notificationCreator.setNotificationChannelProvider(this.notificationChannelProvider);
        return this;
    }

    public DownloadManagerBuilder withNotification(NotificationCustomizer<DownloadBatchStatus> notificationCustomizer) {
        this.notificationCreator = new DownloadBatchStatusNotificationCreator(this.applicationContext, notificationCustomizer, this.notificationChannelProvider);
        return this;
    }

    public DownloadManagerBuilder withAllowedConnectionType(ConnectionType connectionTypeAllowed) {
        this.connectionTypeAllowed = connectionTypeAllowed;
        return this;
    }

    public DownloadManagerBuilder withoutNetworkRecovery() {
        this.allowNetworkRecovery = false;
        return this;
    }

    public DownloadManagerBuilder withCallbackThrottleCustom(Class<? extends FileCallbackThrottle> customCallbackThrottle) {
        this.callbackThrottleCreatorType = CallbackThrottleCreator.Type.CUSTOM;
        this.customCallbackThrottle = customCallbackThrottle;
        return this;
    }

    public DownloadManagerBuilder withCallbackThrottleByTime(TimeUnit timeUnit, long frequency) {
        this.callbackThrottleCreatorType = CallbackThrottleCreator.Type.THROTTLE_BY_TIME;
        this.timeUnit = timeUnit;
        this.frequency = frequency;
        return this;
    }

    public DownloadManagerBuilder withCallbackThrottleByProgressIncrease() {
        this.callbackThrottleCreatorType = CallbackThrottleCreator.Type.THROTTLE_BY_PROGRESS_INCREASE;
        return this;
    }

    public DownloadManagerBuilder withLogHandle(LogHandle logHandle) {
        this.logHandle = Optional.fromNullable(logHandle);
        return this;
    }

    public DownloadManager build() {
        if (this.logHandle.isPresent()) {
            Logger.attach(this.logHandle.get());
        }
        Intent intent = new Intent(this.applicationContext, LiteDownloadService.class);
        ServiceConnection serviceConnection = new ServiceConnection(){

            public void onServiceConnected(ComponentName name, IBinder service) {
                if (service instanceof LiteDownloadService.DownloadServiceBinder) {
                    LiteDownloadService.DownloadServiceBinder binder = (LiteDownloadService.DownloadServiceBinder)service;
                    DownloadManagerBuilder.this.downloadService = binder.getService();
                    DownloadManagerBuilder.this.liteDownloadManager.submitAllStoredDownloads(() -> {
                        DownloadManagerBuilder.this.liteDownloadManager.initialise(DownloadManagerBuilder.this.downloadService);
                        if (DownloadManagerBuilder.this.allowNetworkRecovery) {
                            DownloadsNetworkRecoveryCreator.createEnabled(DownloadManagerBuilder.this.applicationContext, DownloadManagerBuilder.this.liteDownloadManager, DownloadManagerBuilder.this.connectionTypeAllowed);
                        } else {
                            DownloadsNetworkRecoveryCreator.createDisabled();
                        }
                    });
                }
            }

            public void onServiceDisconnected(ComponentName name) {
            }
        };
        this.applicationContext.bindService(intent, serviceConnection, 1);
        this.filePersistenceCreator.withStorageRequirementRules(this.storageRequirementRules);
        FileOperations fileOperations = new FileOperations(this.filePersistenceCreator, this.fileSizeRequester, this.fileDownloaderCreator);
        CopyOnWriteArraySet<DownloadBatchStatusCallback> callbacks = new CopyOnWriteArraySet<DownloadBatchStatusCallback>();
        CallbackThrottleCreator callbackThrottleCreator = this.getCallbackThrottleCreator(this.callbackThrottleCreatorType, this.timeUnit, this.frequency, this.customCallbackThrottle);
        DownloadsFilePersistence downloadsFilePersistence = new DownloadsFilePersistence(this.downloadsPersistence);
        MerlinsBeard merlinsBeard = MerlinsBeard.from((Context)this.applicationContext);
        ConnectionChecker connectionChecker = new ConnectionChecker(merlinsBeard, this.connectionTypeAllowed);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        DownloadsBatchPersistence downloadsBatchPersistence = new DownloadsBatchPersistence(executor, downloadsFilePersistence, this.downloadsPersistence, callbackThrottleCreator, connectionChecker, this.downloadBatchRequirementRules);
        if (Build.VERSION.SDK_INT >= 26) {
            this.notificationChannelProvider.registerNotificationChannel(this.applicationContext);
        }
        Wait.Criteria serviceCriteria = new Wait.Criteria();
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)this.applicationContext);
        ServiceNotificationDispatcher<DownloadBatchStatus> notificationDispatcher = new ServiceNotificationDispatcher<DownloadBatchStatus>(SERVICE_LOCK, serviceCriteria, this.notificationCreator, notificationManager);
        DownloadBatchStatusNotificationDispatcher batchStatusNotificationDispatcher = new DownloadBatchStatusNotificationDispatcher(downloadsBatchPersistence, notificationDispatcher, new HashSet<String>());
        DownloadBatchStatusFilter downloadBatchStatusFilter = new DownloadBatchStatusFilter();
        LiteDownloadManagerDownloader downloader = new LiteDownloadManagerDownloader(SERVICE_LOCK, CALLBACK_LOCK, EXECUTOR, this.callbackHandler, fileOperations, downloadsBatchPersistence, downloadsFilePersistence, batchStatusNotificationDispatcher, this.downloadBatchRequirementRules, connectionChecker, callbacks, callbackThrottleCreator, downloadBatchStatusFilter, serviceCriteria);
        this.liteDownloadManager = new LiteDownloadManager(SERVICE_LOCK, CALLBACK_LOCK, EXECUTOR, this.callbackHandler, new HashMap<DownloadBatchId, DownloadBatch>(), callbacks, fileOperations, downloadsBatchPersistence, downloader, connectionChecker, serviceCriteria);
        return this.liteDownloadManager;
    }

    private CallbackThrottleCreator getCallbackThrottleCreator(CallbackThrottleCreator.Type callbackThrottleType, TimeUnit timeUnit, long frequency, Class<? extends FileCallbackThrottle> customCallbackThrottle) {
        switch (callbackThrottleType) {
            case THROTTLE_BY_TIME: {
                return CallbackThrottleCreator.byTime(timeUnit, frequency);
            }
            case THROTTLE_BY_PROGRESS_INCREASE: {
                return CallbackThrottleCreator.byProgressIncrease();
            }
            case CUSTOM: {
                return CallbackThrottleCreator.byCustomThrottle(customCallbackThrottle);
            }
        }
        throw new IllegalStateException("callbackThrottle type " + (Object)((Object)callbackThrottleType) + " not implemented yet");
    }

    private static class DownloadNotificationCustomizer
    implements NotificationCustomizer<DownloadBatchStatus> {
        private static final boolean NOT_INDETERMINATE = false;
        private final Resources resources;
        private final int notificationIcon;

        DownloadNotificationCustomizer(Resources resources, int notificationIcon) {
            this.resources = resources;
            this.notificationIcon = notificationIcon;
        }

        @Override
        public NotificationCustomizer.NotificationDisplayState notificationDisplayState(DownloadBatchStatus payload) {
            DownloadBatchStatus.Status status = payload.status();
            if (status == DownloadBatchStatus.Status.DOWNLOADED || status == DownloadBatchStatus.Status.DELETED || status == DownloadBatchStatus.Status.DELETING || status == DownloadBatchStatus.Status.ERROR || status == DownloadBatchStatus.Status.PAUSED) {
                return NotificationCustomizer.NotificationDisplayState.STACK_NOTIFICATION_DISMISSIBLE;
            }
            return NotificationCustomizer.NotificationDisplayState.SINGLE_PERSISTENT_NOTIFICATION;
        }

        @Override
        public Notification customNotificationFrom(NotificationCompat.Builder builder, DownloadBatchStatus payload) {
            DownloadBatchTitle downloadBatchTitle = payload.getDownloadBatchTitle();
            String title = downloadBatchTitle.asString();
            builder.setSmallIcon(this.notificationIcon).setContentTitle((CharSequence)title);
            switch (payload.status()) {
                case DELETED: 
                case DELETING: {
                    return this.createDeletedNotification(builder);
                }
                case ERROR: {
                    return this.createErrorNotification(builder, payload.downloadError());
                }
                case DOWNLOADED: {
                    return this.createCompletedNotification(builder);
                }
            }
            return this.createProgressNotification(builder, payload);
        }

        private Notification createDeletedNotification(NotificationCompat.Builder builder) {
            String content = this.resources.getString(R.string.download_notification_content_deleted);
            return builder.setContentText((CharSequence)content).build();
        }

        private Notification createErrorNotification(NotificationCompat.Builder builder, DownloadError downloadError) {
            String content = this.resources.getString(R.string.download_notification_content_error, new Object[]{downloadError.type().name()});
            return builder.setContentText((CharSequence)content).build();
        }

        private Notification createCompletedNotification(NotificationCompat.Builder builder) {
            String content = this.resources.getString(R.string.download_notification_content_completed);
            return builder.setContentText((CharSequence)content).build();
        }

        private Notification createProgressNotification(NotificationCompat.Builder builder, DownloadBatchStatus payload) {
            int bytesFileSize = (int)payload.bytesTotalSize();
            int bytesDownloaded = (int)payload.bytesDownloaded();
            String content = this.resources.getString(R.string.download_notification_content_progress, new Object[]{payload.percentageDownloaded()});
            return builder.setProgress(bytesFileSize, bytesDownloaded, false).setContentText((CharSequence)content).build();
        }
    }
}

