/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import android.support.annotation.WorkerThread;
import com.novoda.downloadmanager.DownloadBatchId;
import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadErrorFactory;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileStatus;
import com.novoda.downloadmanager.DownloadsFilePersistence;
import com.novoda.downloadmanager.FileDownloader;
import com.novoda.downloadmanager.FilePath;
import com.novoda.downloadmanager.FilePersistence;
import com.novoda.downloadmanager.FilePersistenceResult;
import com.novoda.downloadmanager.FileSize;
import com.novoda.downloadmanager.FileSizeRequester;
import com.novoda.downloadmanager.InternalDownloadFileStatus;
import com.novoda.downloadmanager.InternalFileSize;
import com.novoda.downloadmanager.Logger;

class DownloadFile {
    private final DownloadBatchId downloadBatchId;
    private final DownloadFileId downloadFileId;
    private final String url;
    private final InternalDownloadFileStatus downloadFileStatus;
    private final FileDownloader fileDownloader;
    private final FileSizeRequester fileSizeRequester;
    private final FilePersistence filePersistence;
    private final DownloadsFilePersistence downloadsFilePersistence;
    private final FilePath filePath;
    private InternalFileSize fileSize;

    DownloadFile(DownloadBatchId downloadBatchId, DownloadFileId downloadFileId, String url, InternalDownloadFileStatus downloadFileStatus, FilePath filePath, InternalFileSize fileSize, FileDownloader fileDownloader, FileSizeRequester fileSizeRequester, FilePersistence filePersistence, DownloadsFilePersistence downloadsFilePersistence) {
        this.downloadBatchId = downloadBatchId;
        this.downloadFileId = downloadFileId;
        this.url = url;
        this.downloadFileStatus = downloadFileStatus;
        this.filePath = filePath;
        this.fileDownloader = fileDownloader;
        this.fileSizeRequester = fileSizeRequester;
        this.filePersistence = filePersistence;
        this.fileSize = fileSize;
        this.downloadsFilePersistence = downloadsFilePersistence;
    }

    void download(final Callback callback) {
        this.downloadFileStatus.markAsDownloading();
        callback.onUpdate(this.downloadFileStatus);
        this.fileSize = this.requestTotalFileSizeIfNecessary(this.fileSize);
        if (this.fileSize.isTotalSizeUnknown()) {
            DownloadError downloadError = DownloadErrorFactory.createTotalSizeRequestFailedError(this.downloadFileId, this.url);
            this.updateAndFeedbackWithStatus(downloadError, callback);
            return;
        }
        this.fileSize.setCurrentSize(this.filePersistence.getCurrentSize(this.filePath));
        if (this.downloadFileStatus.isMarkedAsDeleted()) {
            return;
        }
        Logger.v("persist file " + this.downloadFileId.rawId() + ", with status: " + (Object)((Object)this.downloadFileStatus.status()));
        if (!this.persist()) {
            Logger.e("persisting file " + this.downloadFileId.rawId() + " with status " + (Object)((Object)this.downloadFileStatus.status()) + " failed");
            return;
        }
        if (this.fileSize.currentSize() == this.fileSize.totalSize()) {
            this.downloadFileStatus.update(this.fileSize, this.filePath);
            callback.onUpdate(this.downloadFileStatus);
            return;
        }
        FilePersistenceResult result = this.filePersistence.create(this.filePath, this.fileSize);
        if (result != FilePersistenceResult.SUCCESS) {
            DownloadError downloadError = this.convertError(result);
            this.updateAndFeedbackWithStatus(downloadError, callback);
            return;
        }
        this.fileDownloader.startDownloading(this.url, this.fileSize, new FileDownloader.Callback(){

            @Override
            public void onBytesRead(byte[] buffer, int bytesRead) {
                boolean success = DownloadFile.this.filePersistence.write(buffer, 0, bytesRead);
                if (!success) {
                    DownloadError downloadError = DownloadErrorFactory.createCannotWriteToFileError(DownloadFile.this.downloadFileStatus);
                    DownloadFile.this.updateAndFeedbackWithStatus(downloadError, callback);
                }
                if (DownloadFile.this.downloadFileStatus.isMarkedAsDownloading()) {
                    DownloadFile.this.fileSize.addToCurrentSize(bytesRead);
                    DownloadFile.this.downloadFileStatus.update(DownloadFile.this.fileSize, DownloadFile.this.filePath);
                    callback.onUpdate(DownloadFile.this.downloadFileStatus);
                }
            }

            @Override
            public void onError(String cause) {
                DownloadError downloadError = DownloadErrorFactory.createNetworkError(cause);
                DownloadFile.this.updateAndFeedbackWithStatus(downloadError, callback);
            }

            @Override
            public void onDownloadFinished() {
                DownloadFile.this.filePersistence.close();
                if (DownloadFile.this.downloadFileStatus.isMarkedAsDeleted()) {
                    DownloadFile.this.filePersistence.delete(DownloadFile.this.filePath);
                }
                if (DownloadFile.this.downloadFileStatus.isMarkedAsWaitingForNetwork()) {
                    callback.onUpdate(DownloadFile.this.downloadFileStatus);
                }
            }
        });
    }

    private DownloadError convertError(FilePersistenceResult status) {
        switch (status) {
            case ERROR_UNKNOWN_TOTAL_FILE_SIZE: {
                return DownloadErrorFactory.createTotalSizeRequestFailedError(this.downloadFileId, this.url);
            }
            case ERROR_INSUFFICIENT_SPACE: {
                return DownloadErrorFactory.createInsufficientFreeSpaceError(this.downloadFileStatus);
            }
            case ERROR_OPENING_FILE: {
                return DownloadErrorFactory.createCannotWriteToFileError(this.downloadFileStatus);
            }
        }
        Logger.e("Status " + (Object)((Object)status) + " missing to be processed");
        return DownloadErrorFactory.createUnknownErrorFor(status);
    }

    private InternalFileSize requestTotalFileSizeIfNecessary(InternalFileSize fileSize) {
        FileSize requestFileSize;
        InternalFileSize updatedFileSize = fileSize.copy();
        if (fileSize.isTotalSizeUnknown() && (requestFileSize = this.fileSizeRequester.requestFileSize(this.url)).isTotalSizeKnown()) {
            updatedFileSize.setTotalSize(requestFileSize.totalSize());
        }
        return updatedFileSize;
    }

    private void updateAndFeedbackWithStatus(DownloadError downloadError, Callback callback) {
        this.downloadFileStatus.markAsError(downloadError);
        callback.onUpdate(this.downloadFileStatus);
    }

    void pause() {
        this.downloadFileStatus.markAsPaused();
        this.fileDownloader.stopDownloading();
    }

    void resume() {
        this.downloadFileStatus.markAsQueued();
    }

    void waitForNetwork() {
        this.downloadFileStatus.waitForNetwork();
        this.fileDownloader.stopDownloading();
    }

    void delete() {
        if (this.downloadFileStatus.isMarkedAsDownloading()) {
            this.downloadFileStatus.markAsDeleted();
            Logger.v("mark file as deleted for batchId: " + this.downloadBatchId.rawId());
            this.fileDownloader.stopDownloading();
        } else {
            this.downloadFileStatus.markAsDeleted();
            Logger.v("mark file as deleted for batchId: " + this.downloadBatchId.rawId());
            this.filePersistence.delete(this.filePath);
        }
    }

    @WorkerThread
    long getTotalSize() {
        if (this.fileSize.isTotalSizeUnknown()) {
            FileSize requestFileSize = this.fileSizeRequester.requestFileSize(this.url);
            this.fileSize.setTotalSize(requestFileSize.totalSize());
            if (this.fileStatus().status() == DownloadFileStatus.Status.DELETED) {
                Logger.e("file getTotalSize return zero because is deleted, " + this.downloadFileId.rawId() + " from batch " + this.downloadBatchId.rawId() + " with file status " + (Object)((Object)this.fileStatus().status()));
                return 0L;
            }
            this.persist();
        }
        return this.fileSize.totalSize();
    }

    @WorkerThread
    boolean persist() {
        return this.downloadsFilePersistence.persistSync(this.downloadBatchId, this.filePath, this.fileSize, this.url, this.downloadFileStatus);
    }

    long getCurrentDownloadedBytes() {
        return this.fileSize.currentSize();
    }

    DownloadFileId id() {
        return this.downloadFileStatus.downloadFileId();
    }

    boolean matches(DownloadFileId downloadFileId) {
        return this.downloadFileId.equals(downloadFileId);
    }

    DownloadFileStatus fileStatus() {
        return this.downloadFileStatus;
    }

    static interface Callback {
        public void onUpdate(InternalDownloadFileStatus var1);
    }
}

