/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.DownloadError;
import com.novoda.downloadmanager.DownloadFileId;
import com.novoda.downloadmanager.DownloadFileStatus;
import com.novoda.downloadmanager.FilePersistenceResult;

final class DownloadErrorFactory {
    private DownloadErrorFactory() {
    }

    static DownloadError createSizeMismatchError(DownloadFileStatus downloadFileStatus) {
        String sizeMismatchMessage = "Download File with ID: " + downloadFileStatus.downloadBatchId().rawId() + " has a greater current size: " + downloadFileStatus.bytesDownloaded() + " than the total size: " + downloadFileStatus.totalBytes();
        return new DownloadError(DownloadError.Type.FILE_CURRENT_AND_TOTAL_SIZE_MISMATCH, sizeMismatchMessage);
    }

    static DownloadError createTotalSizeRequestFailedError(DownloadFileId downloadFileId, String url) {
        String totalSizeRequestFailedMessage = "Total size request failed for File with ID: " + downloadFileId.rawId() + " and Request: " + url;
        return new DownloadError(DownloadError.Type.FILE_TOTAL_SIZE_REQUEST_FAILED, totalSizeRequestFailedMessage);
    }

    static DownloadError createInsufficientFreeSpaceError(DownloadFileStatus downloadFileStatus) {
        String insufficientFreeSpaceMessage = "Insufficient free space to create file with ID: " + downloadFileStatus.downloadFileId().rawId() + " Bytes Required: " + downloadFileStatus.totalBytes();
        return new DownloadError(DownloadError.Type.FILE_CANNOT_BE_CREATED_LOCALLY_INSUFFICIENT_FREE_SPACE, insufficientFreeSpaceMessage);
    }

    static DownloadError createCannotWriteToFileError(DownloadFileStatus downloadFileStatus) {
        String cannotWriteToFileMessage = "Cannot write to file with Id: " + downloadFileStatus.downloadFileId().rawId();
        return new DownloadError(DownloadError.Type.FILE_CANNOT_BE_WRITTEN, cannotWriteToFileMessage);
    }

    static DownloadError createNetworkError(String networkErrorCause) {
        String networkErrorMessage = "Network error, cannot download file. Cause: " + networkErrorCause;
        return new DownloadError(DownloadError.Type.NETWORK_ERROR_CANNOT_DOWNLOAD_FILE, networkErrorMessage);
    }

    static DownloadError createUnknownErrorFor(FilePersistenceResult status) {
        String unknownErrorMessage = "Unhandled error for FilePersistenceResult: " + status.name();
        return new DownloadError(DownloadError.Type.UNKNOWN, unknownErrorMessage);
    }
}

