/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

public class DownloadError {
    private final Type type;
    private final String message;

    DownloadError(Type type, String message) {
        this.type = type;
        this.message = message;
    }

    DownloadError(Type type) {
        this.type = type;
        this.message = "";
    }

    public Type type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadError that = (DownloadError)o;
        if (this.type != that.type) {
            return false;
        }
        return this.message != null ? this.message.equals(that.message) : that.message == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DownloadError{type=" + (Object)((Object)this.type) + ", message='" + this.message + '\'' + '}';
    }

    public static enum Type {
        FILE_CURRENT_AND_TOTAL_SIZE_MISMATCH,
        FILE_TOTAL_SIZE_REQUEST_FAILED,
        FILE_CANNOT_BE_CREATED_LOCALLY_INSUFFICIENT_FREE_SPACE,
        FILE_CANNOT_BE_WRITTEN,
        NETWORK_ERROR_CANNOT_DOWNLOAD_FILE,
        REQUIREMENT_RULE_VIOLATED,
        UNKNOWN;

    }
}

