/*
 * Decompiled with CFR 0.152.
 */
package com.novoda.downloadmanager;

import com.novoda.downloadmanager.DownloadBatchStatus;
import com.novoda.downloadmanager.DownloadService;
import com.novoda.downloadmanager.DownloadsNotificationSeenPersistence;
import com.novoda.downloadmanager.Logger;
import com.novoda.downloadmanager.ServiceNotificationDispatcher;
import java.util.Set;

class DownloadBatchStatusNotificationDispatcher {
    private static final boolean NOTIFICATION_SEEN = true;
    private final DownloadsNotificationSeenPersistence notificationSeenPersistence;
    private final ServiceNotificationDispatcher<DownloadBatchStatus> notificationDispatcher;
    private final Set<String> downloadBatchIdNotificationSeen;

    DownloadBatchStatusNotificationDispatcher(DownloadsNotificationSeenPersistence notificationSeenPersistence, ServiceNotificationDispatcher<DownloadBatchStatus> notificationDispatcher, Set<String> downloadBatchIdNotificationSeen) {
        this.notificationSeenPersistence = notificationSeenPersistence;
        this.notificationDispatcher = notificationDispatcher;
        this.downloadBatchIdNotificationSeen = downloadBatchIdNotificationSeen;
    }

    void updateNotification(DownloadBatchStatus downloadBatchStatus) {
        if (downloadBatchStatus.notificationSeen()) {
            Logger.v("DownloadBatchStatus:", downloadBatchStatus.getDownloadBatchId(), "notification has already been seen.");
            return;
        }
        String rawDownloadBatchId = downloadBatchStatus.getDownloadBatchId().rawId();
        if (downloadBatchStatus.status() == DownloadBatchStatus.Status.DELETED) {
            this.downloadBatchIdNotificationSeen.remove(rawDownloadBatchId);
        }
        if (this.notificationIsNotMarkedAsSeenYet(downloadBatchStatus, rawDownloadBatchId)) {
            this.downloadBatchIdNotificationSeen.add(rawDownloadBatchId);
            Logger.v("start updateNotificationSeenAsync " + rawDownloadBatchId + ", seen: " + true + ", status: " + (Object)((Object)downloadBatchStatus.status()));
            this.notificationSeenPersistence.updateNotificationSeenAsync(downloadBatchStatus, true);
        }
        this.notificationDispatcher.updateNotification(downloadBatchStatus);
    }

    private boolean notificationIsNotMarkedAsSeenYet(DownloadBatchStatus downloadBatchStatus, String rawDownloadBatchId) {
        return downloadBatchStatus.status() == DownloadBatchStatus.Status.DOWNLOADED && !this.downloadBatchIdNotificationSeen.contains(rawDownloadBatchId);
    }

    void setDownloadService(DownloadService downloadService) {
        this.notificationDispatcher.setService(downloadService);
    }
}

